/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.component.ComponentsBundle;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.component.ComponentsXmlParser;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.xml.BaseSaxParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRReportSaxParserFactory
extends BaseSaxParserFactory {
    private static final Log log = LogFactory.getLog(JRReportSaxParserFactory.class);

    @Override
    protected boolean isValidating() {
        return JRProperties.getBooleanProperty("net.sf.jasperreports.compiler.xml.validation");
    }

    @Override
    protected List<String> getSchemaLocations() {
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add(this.getResourceURI("net/sf/jasperreports/engine/dtds/jasperreport.xsd"));
        schemas.add(this.getResourceURI("net/sf/jasperreports/engine/dtds/jasperreport-dtd-compat.xsd"));
        Collection<ComponentsBundle> components = ComponentsEnvironment.getComponentBundles();
        for (ComponentsBundle componentManager : components) {
            ComponentsXmlParser xmlParser = componentManager.getXmlParser();
            String schemaResource = xmlParser.getInternalSchemaResource();
            String schemaURI = schemaResource != null ? this.getResourceURI(schemaResource) : xmlParser.getPublicSchemaLocation();
            if (log.isDebugEnabled()) {
                log.debug("Adding components schema at " + schemaURI);
            }
            schemas.add(schemaURI);
        }
        return schemas;
    }
}

