/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JRSqlAbstractInClause
implements JRClauseFunction {
    protected static final int POSITION_DB_COLUMN = 1;
    protected static final int POSITION_PARAMETER = 2;
    protected static final String CLAUSE_TRUISM = "0 = 0";

    protected JRSqlAbstractInClause() {
    }

    @Override
    public void apply(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext) {
        String col = clauseTokens.getToken(1);
        String param = clauseTokens.getToken(2);
        if (col == null) {
            throw new JRRuntimeException("SQL IN clause missing DB column token");
        }
        if (param == null) {
            throw new JRRuntimeException("SQL IN clause missing parameter token");
        }
        StringBuffer sbuffer = queryContext.queryBuffer();
        Object paramValue = queryContext.getValueParameter(param).getValue();
        if (paramValue == null) {
            this.handleNoValues(queryContext);
        } else {
            Collection<?> paramCollection = this.convert(param, paramValue);
            int count = paramCollection.size();
            Iterator<?> it = paramCollection.iterator();
            if (count == 0) {
                this.handleNoValues(queryContext);
            } else {
                StringBuffer nullSbuffer = new StringBuffer();
                StringBuffer notNullSbuffer = new StringBuffer();
                boolean nullFound = false;
                boolean notNullFound = false;
                int idx = 0;
                ArrayList notNullQueryParameters = new ArrayList();
                while (it.hasNext()) {
                    Object element = it.next();
                    if (element == null) {
                        if (nullFound) continue;
                        nullFound = true;
                        nullSbuffer.append(col);
                        nullSbuffer.append(' ');
                        this.appendNullOperator(nullSbuffer);
                        continue;
                    }
                    if (!notNullFound) {
                        notNullFound = true;
                        notNullSbuffer.append(col);
                        notNullSbuffer.append(' ');
                        this.appendInOperator(notNullSbuffer);
                        notNullSbuffer.append(' ');
                        notNullSbuffer.append('(');
                    }
                    if (idx > 0) {
                        notNullSbuffer.append(", ");
                    }
                    notNullSbuffer.append('?');
                    notNullQueryParameters.add(element);
                    ++idx;
                }
                if (nullFound) {
                    if (notNullFound) {
                        sbuffer.append("( ");
                        sbuffer.append(nullSbuffer);
                        this.appendAndOrOperator(sbuffer);
                    } else {
                        sbuffer.append(nullSbuffer);
                    }
                }
                if (notNullFound) {
                    notNullSbuffer.append(')');
                    if (nullFound) {
                        notNullSbuffer.append(" )");
                    }
                    sbuffer.append(notNullSbuffer);
                    queryContext.addQueryMultiParameters(param, count, nullFound);
                }
            }
        }
    }

    protected void handleNoValues(JRQueryClauseContext queryContext) {
        queryContext.queryBuffer().append(CLAUSE_TRUISM);
    }

    protected Collection<?> convert(String paramName, Object paramValue) {
        ArrayList<Object> paramCollection;
        if (paramValue.getClass().isArray()) {
            int size = Array.getLength(paramValue);
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int i2 = 0; i2 < size; ++i2) {
                list.add(Array.get(paramValue, i2));
            }
            paramCollection = list;
        } else if (paramValue instanceof Collection) {
            paramCollection = (ArrayList<Object>)paramValue;
        } else {
            throw new JRRuntimeException("Invalid type " + paramValue.getClass().getName() + " for parameter " + paramName + " used in an IN clause; the value must be an array or a collection.");
        }
        return paramCollection;
    }

    protected abstract void appendInOperator(StringBuffer var1);

    protected abstract void appendNullOperator(StringBuffer var1);

    protected abstract void appendAndOrOperator(StringBuffer var1);
}

