/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRHorizontalFiller;
import net.sf.jasperreports.engine.fill.JRVerticalFiller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JRFiller {
    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters, Connection conn) throws JRException {
        JRBaseFiller filler = JRFiller.createFiller(jasperReport);
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = filler.fill(parameters, conn);
        }
        catch (JRFillInterruptedException e2) {
            throw new JRException("The report filling thread was interrupted.", e2);
        }
        return jasperPrint;
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JRBaseFiller filler = JRFiller.createFiller(jasperReport);
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = filler.fill(parameters, dataSource);
        }
        catch (JRFillInterruptedException e2) {
            throw new JRException("The report filling thread was interrupted.", e2);
        }
        return jasperPrint;
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters) throws JRException {
        JRBaseFiller filler = JRFiller.createFiller(jasperReport);
        try {
            JasperPrint jasperPrint = filler.fill(parameters);
            return jasperPrint;
        }
        catch (JRFillInterruptedException e2) {
            throw new JRException("The report filling thread was interrupted.", e2);
        }
    }

    public static JRBaseFiller createFiller(JasperReport jasperReport) throws JRException {
        JRBaseFiller filler = null;
        switch (jasperReport.getPrintOrderValue()) {
            case HORIZONTAL: {
                filler = new JRHorizontalFiller(jasperReport);
                break;
            }
            case VERTICAL: {
                filler = new JRVerticalFiller(jasperReport);
            }
        }
        return filler;
    }

    private JRFiller() {
    }
}

