/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRBigDecimalAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalCountIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalDistinctCountIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalSumIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalVarianceIncrementer;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.type.CalculationEnum;

public final class JRBigDecimalIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    protected static final BigDecimal ZERO = BigDecimal.ZERO;
    protected static final BigDecimal ONE = BigDecimal.ONE;
    private static JRBigDecimalIncrementerFactory mainInstance = new JRBigDecimalIncrementerFactory();

    private JRBigDecimalIncrementerFactory() {
    }

    public static JRBigDecimalIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRExtendedIncrementer getExtendedIncrementer(CalculationEnum calculation) {
        JRExtendedIncrementer incrementer = null;
        switch (calculation) {
            case COUNT: {
                incrementer = JRBigDecimalCountIncrementer.getInstance();
                break;
            }
            case SUM: {
                incrementer = JRBigDecimalSumIncrementer.getInstance();
                break;
            }
            case AVERAGE: {
                incrementer = JRBigDecimalAverageIncrementer.getInstance();
                break;
            }
            case LOWEST: 
            case HIGHEST: {
                incrementer = JRComparableIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
                break;
            }
            case STANDARD_DEVIATION: {
                incrementer = JRBigDecimalStandardDeviationIncrementer.getInstance();
                break;
            }
            case VARIANCE: {
                incrementer = JRBigDecimalVarianceIncrementer.getInstance();
                break;
            }
            case DISTINCT_COUNT: {
                incrementer = JRBigDecimalDistinctCountIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
            }
        }
        return incrementer;
    }

    protected static BigDecimal toBigDecimal(Object value) {
        BigDecimal bigDecimal;
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            bigDecimal = (BigDecimal)value;
        } else if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            bigDecimal = BigDecimal.valueOf(((Number)value).longValue());
        } else if (value instanceof BigInteger) {
            bigDecimal = new BigDecimal((BigInteger)value);
        } else if (value instanceof Number) {
            bigDecimal = BigDecimal.valueOf(((Number)value).doubleValue());
        } else {
            throw new JRRuntimeException("Value " + value + " of type " + value.getClass().getName() + " unsupported for BigDecimal conversion");
        }
        return bigDecimal;
    }
}

