/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.VirtualizationObjectInputStream;
import net.sf.jasperreports.engine.fill.VirtualizationObjectOutputStream;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRAbstractLRUVirtualizer
implements JRVirtualizer {
    private static final Log log = LogFactory.getLog(JRAbstractLRUVirtualizer.class);
    protected static final int CLASSLOADER_IDX_NOT_SET = -1;
    protected final Map<ClassLoader, Integer> classLoadersIndexes = new HashMap<ClassLoader, Integer>();
    protected final List<ClassLoader> classLoadersList = new ArrayList<ClassLoader>();
    private final Cache pagedIn;
    private final ReferenceMap pagedOut;
    protected JRVirtualizable lastObject;
    protected ReferenceMap lastObjectMap;
    protected ReferenceMap lastObjectSet;
    private boolean readOnly;

    protected static boolean isAncestorClassLoader(ClassLoader loader) {
        for (ClassLoader ancestor = JRAbstractLRUVirtualizer.class.getClassLoader(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!ancestor.equals(loader)) continue;
            return true;
        }
        return false;
    }

    protected JRAbstractLRUVirtualizer(int maxSize) {
        this.pagedIn = new Cache(maxSize);
        this.pagedOut = new ReferenceMap(0, 2);
        this.lastObject = null;
        this.lastObjectMap = new ReferenceMap(2, 2);
        this.lastObjectSet = new ReferenceMap(2, 0);
    }

    protected final synchronized boolean isPagedOut(String id) {
        return this.pagedOut.containsKey(id);
    }

    protected synchronized boolean isPagedOutAndTouch(JRVirtualizable o2, String uid) {
        boolean virtualized = this.isPagedOut(uid);
        if (!virtualized) {
            this.touch(o2);
        }
        return virtualized;
    }

    protected final void setLastObject(JRVirtualizable o2) {
        if (this.lastObject != o2) {
            JRVirtualizationContext context;
            Object ownerLast;
            if (o2 != null && (ownerLast = this.lastObjectMap.get(context = o2.getContext())) != o2) {
                if (ownerLast != null) {
                    this.lastObjectSet.remove(ownerLast);
                }
                this.lastObjectMap.put(context, o2);
                this.lastObjectSet.put(o2, Boolean.TRUE);
            }
            this.lastObject = o2;
        }
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected final boolean isReadOnly(JRVirtualizable o2) {
        return this.readOnly || o2.getContext().isReadOnly();
    }

    public synchronized void registerObject(JRVirtualizable o2) {
        this.setLastObject(o2);
        JRVirtualizable old = this.pagedIn.put(o2.getUID(), o2);
        if (old != null && old != o2) {
            this.pagedIn.put(o2.getUID(), old);
            throw new IllegalStateException("Wrong object stored with UID \"" + o2.getUID() + "\"");
        }
        if (log.isDebugEnabled()) {
            log.debug("registered object " + o2 + " with id " + o2.getUID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterObject(JRVirtualizable o2) {
        String uid = o2.getUID();
        try {
            this.dispose(o2.getUID());
        }
        catch (Exception e2) {
            log.error("Error removing virtual data", e2);
        }
        JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
        synchronized (jRAbstractLRUVirtualizer) {
            JRVirtualizable oldIn = this.pagedIn.remove(uid);
            if (oldIn != null) {
                if (oldIn != o2) {
                    this.pagedIn.put(uid, oldIn);
                    throw new IllegalStateException("Wrong object stored with UID \"" + o2.getUID() + "\"");
                }
            } else {
                Object oldOut = this.pagedOut.remove(uid);
                if (oldOut != null && oldOut != o2) {
                    this.pagedOut.put(uid, oldOut);
                    throw new IllegalStateException("Wrong object stored with UID \"" + o2.getUID() + "\"");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("deregistered object " + o2 + " with id " + o2.getUID());
        }
    }

    public synchronized void touch(JRVirtualizable o2) {
        if (this.lastObject != o2) {
            this.setLastObject(this.pagedIn.get(o2.getUID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestData(JRVirtualizable o2) {
        String uid = o2.getUID();
        if (this.isPagedOutAndTouch(o2, uid)) {
            if (log.isDebugEnabled()) {
                log.debug("internalizing " + uid);
            }
            try {
                this.pageIn(o2);
            }
            catch (IOException e2) {
                log.error("Error devirtualizing object", e2);
                throw new JRRuntimeException(e2);
            }
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.setLastObject(o2);
                this.pagedOut.remove(uid);
                this.pagedIn.put(uid, o2);
            }
            o2.afterInternalization();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData(JRVirtualizable o2) {
        String uid = o2.getUID();
        if (this.isPagedOutAndTouch(o2, uid)) {
            this.dispose(uid);
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.pagedOut.remove(uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void virtualizeData(JRVirtualizable o2) {
        String uid = o2.getUID();
        if (!this.isPagedOut(uid)) {
            if (log.isDebugEnabled()) {
                log.debug("externalizing " + uid);
            }
            o2.beforeExternalization();
            try {
                this.pageOut(o2);
            }
            catch (IOException e2) {
                log.error("Error virtualizing object", e2);
                throw new JRRuntimeException(e2);
            }
            o2.afterExternalization();
            o2.removeVirtualData();
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.pagedOut.put(uid, o2);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    protected final void writeData(JRVirtualizable o2, OutputStream out) throws JRRuntimeException {
        try {
            ClassLoaderAnnotationObjectOutputStream oos = new ClassLoaderAnnotationObjectOutputStream(out, o2.getContext());
            oos.writeObject(o2.getVirtualData());
            oos.flush();
        }
        catch (IOException e2) {
            log.error("Error virtualizing object", e2);
            throw new JRRuntimeException(e2);
        }
    }

    protected final void readData(JRVirtualizable o2, InputStream in) throws JRRuntimeException {
        try {
            ClassLoaderAnnotationObjectInputStream ois = new ClassLoaderAnnotationObjectInputStream(in, o2.getContext());
            o2.setVirtualData(ois.readObject());
        }
        catch (IOException e2) {
            log.error("Error devirtualizing object", e2);
            throw new JRRuntimeException(e2);
        }
        catch (ClassNotFoundException e3) {
            log.error("Error devirtualizing object", e3);
            throw new JRRuntimeException(e3);
        }
    }

    protected synchronized void reset() {
        this.readOnly = false;
    }

    protected final void disposeAll() {
        String id;
        Iterator<Object> it = this.pagedOut.keySet().iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            try {
                this.dispose(id);
                it.remove();
            }
            catch (Exception e2) {
                log.error("Error cleaning up virtualizer.", e2);
            }
        }
        it = this.pagedIn.idIterator();
        while (it.hasNext()) {
            id = (String)it.next();
            try {
                this.dispose(id);
                it.remove();
            }
            catch (Exception e3) {
                log.error("Error cleaning up virtualizer.", e3);
            }
        }
    }

    protected abstract void pageOut(JRVirtualizable var1) throws IOException;

    protected abstract void pageIn(JRVirtualizable var1) throws IOException;

    protected abstract void dispose(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassLoaderAnnotationObjectInputStream
    extends VirtualizationObjectInputStream {
        public ClassLoaderAnnotationObjectInputStream(InputStream in, JRVirtualizationContext virtualizationContext) throws IOException {
            super(in, virtualizationContext);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class<?> clazz;
            try {
                clazz = super.resolveClass(desc);
                this.readShort();
            }
            catch (ClassNotFoundException e2) {
                short loaderIdx = this.readShort();
                if (loaderIdx == -1) {
                    throw e2;
                }
                ClassLoader loader = JRAbstractLRUVirtualizer.this.classLoadersList.get(loaderIdx);
                clazz = Class.forName(desc.getName(), false, loader);
            }
            return clazz;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassLoaderAnnotationObjectOutputStream
    extends VirtualizationObjectOutputStream {
        public ClassLoaderAnnotationObjectOutputStream(OutputStream out, JRVirtualizationContext virtualizationContext) throws IOException {
            super(out, virtualizationContext);
        }

        @Override
        protected void annotateClass(Class<?> clazz) throws IOException {
            int loaderIdx;
            super.annotateClass(clazz);
            ClassLoader classLoader = clazz.getClassLoader();
            if (clazz.isPrimitive() || classLoader == null || JRAbstractLRUVirtualizer.isAncestorClassLoader(classLoader)) {
                loaderIdx = -1;
            } else {
                Integer idx = JRAbstractLRUVirtualizer.this.classLoadersIndexes.get(classLoader);
                if (idx == null) {
                    idx = JRAbstractLRUVirtualizer.this.classLoadersList.size();
                    JRAbstractLRUVirtualizer.this.classLoadersIndexes.put(classLoader, idx);
                    JRAbstractLRUVirtualizer.this.classLoadersList.add(classLoader);
                }
                loaderIdx = idx;
            }
            this.writeShort(loaderIdx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Cache {
        private final ReferenceQueue<JRVirtualizable> refQueue;
        private final LRUScanMap map;

        Cache(int maxSize) {
            this.map = new LRUScanMap(maxSize);
            this.refQueue = new ReferenceQueue();
        }

        protected JRVirtualizable getMapValue(Object val) {
            Reference ref;
            JRVirtualizable o2 = val == null ? null : ((ref = (Reference)val).isEnqueued() ? null : (JRVirtualizable)ref.get());
            return o2;
        }

        protected Object toMapValue(JRVirtualizable val) {
            return val == null ? null : new CacheReference(val, this.refQueue);
        }

        protected void purge() {
            CacheReference ref;
            while ((ref = (CacheReference)this.refQueue.poll()) != null) {
                this.map.remove(ref.getId());
            }
        }

        public JRVirtualizable get(String id) {
            this.purge();
            return this.getMapValue(this.map.get(id));
        }

        public JRVirtualizable put(String id, JRVirtualizable o2) {
            this.purge();
            return this.getMapValue(this.map.put(id, this.toMapValue(o2)));
        }

        public JRVirtualizable remove(String id) {
            this.purge();
            return this.getMapValue(this.map.remove(id));
        }

        public Iterator<String> idIterator() {
            this.purge();
            final Iterator valsIt = this.map.values().iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return valsIt.hasNext();
                }

                @Override
                public String next() {
                    CacheReference ref = (CacheReference)valsIt.next();
                    return ref.getId();
                }

                @Override
                public void remove() {
                    valsIt.remove();
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class LRUScanMap
        extends LRUMap {
            private static final long serialVersionUID = 10200L;

            public LRUScanMap(int maxSize) {
                super(maxSize);
            }

            @Override
            protected void removeLRU() {
                Map.Entry entry = this.getFirst();
                boolean found = this.isRemovable(entry);
                if (!found) {
                    Iterator entriesIt = this.entrySet().iterator();
                    entriesIt.next();
                    while (!found && entriesIt.hasNext()) {
                        entry = (Map.Entry)entriesIt.next();
                        found = this.isRemovable(entry);
                    }
                }
                if (!found) {
                    log.warn("The virtualizer is used by more contexts than its in-memory cache size " + this.getMaximumSize());
                    return;
                }
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.remove(key);
                this.processRemovedLRU(key, value);
            }

            protected boolean isRemovable(Map.Entry<?, ?> entry) {
                JRVirtualizable value = Cache.this.getMapValue(entry.getValue());
                return value == null || !JRAbstractLRUVirtualizer.this.lastObjectSet.containsKey(value);
            }

            @Override
            protected void processRemovedLRU(Object key, Object value) {
                JRVirtualizable o2 = Cache.this.getMapValue(value);
                if (o2 != null) {
                    JRAbstractLRUVirtualizer.this.virtualizeData(o2);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CacheReference
    extends WeakReference<JRVirtualizable> {
        private final String id;

        public CacheReference(JRVirtualizable o2, ReferenceQueue<JRVirtualizable> queue) {
            super(o2, queue);
            this.id = o2.getUID();
        }

        public String getId() {
            return this.id;
        }
    }
}

