/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.export.draw.Offset;
import net.sf.jasperreports.engine.export.draw.PrintDrawVisitor;
import net.sf.jasperreports.engine.util.UniformElementVisitor;

public class DrawVisitor
extends UniformElementVisitor {
    protected ConvertVisitor convertVisitor;
    protected PrintDrawVisitor drawVisitor;

    public DrawVisitor(JRReport report, Graphics2D grx) {
        this(new ReportConverter(report, true), grx);
        this.setTextRenderer(report);
    }

    public DrawVisitor(ReportConverter reportConverter, Graphics2D grx) {
        this.convertVisitor = new ConvertVisitor(reportConverter);
        this.drawVisitor = new PrintDrawVisitor();
        this.setTextRenderer(reportConverter.getReport());
        this.setGraphics2D(grx);
        this.drawVisitor.setClip(true);
    }

    public void setGraphics2D(Graphics2D grx) {
        this.drawVisitor.setGraphics2D(grx);
    }

    public void setTextRenderer(JRReport report) {
        this.drawVisitor.setTextRenderer(report);
    }

    public void visitBreak(JRBreak breakElement) {
    }

    protected void visitElement(JRElement element) {
        JRPrintElement printElement = this.convertVisitor.getVisitPrintElement(element);
        printElement.accept(this.drawVisitor, this.elementOffset(element));
    }

    protected Offset elementOffset(JRElement element) {
        return new Offset(-element.getX(), -element.getY());
    }

    public void visitElementGroup(JRElementGroup elementGroup) {
    }
}

