/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.Serializable;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.collections.ReferenceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JRAbstractJavaCompiler
extends JRAbstractCompiler {
    public static final String PROPERTY_EVALUATOR_CLASS_REFERENCE_FIX_ENABLED = "net.sf.jasperreports.evaluator.class.reference.fix.enabled";
    private static ThreadLocal<Class<?>> classFromBytesRef = new ThreadLocal();
    private static final Object CLASS_CACHE_NULL_KEY = new Object();
    private static Map<Object, Map<String, Class<?>>> classCache = new ReferenceMap(2, 1);

    protected JRAbstractJavaCompiler(boolean needsSourceFiles) {
        super(needsSourceFiles);
    }

    @Override
    protected JREvaluator loadEvaluator(Serializable compileData, String className) throws JRException {
        JREvaluator evaluator = null;
        try {
            Class<?> clazz = JRAbstractJavaCompiler.getClassFromCache(className);
            if (clazz == null) {
                clazz = JRClassLoader.loadClassFromBytes(className, (byte[])compileData);
                JRAbstractJavaCompiler.putClassInCache(className, clazz);
            }
            if (JRProperties.getBooleanProperty(PROPERTY_EVALUATOR_CLASS_REFERENCE_FIX_ENABLED)) {
                classFromBytesRef.set(clazz);
            }
            evaluator = (JREvaluator)clazz.newInstance();
        }
        catch (Exception e2) {
            throw new JRException("Error loading expression class : " + className, e2);
        }
        return evaluator;
    }

    protected static Object classCacheKey() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return contextClassLoader == null ? CLASS_CACHE_NULL_KEY : contextClassLoader;
    }

    protected static synchronized Class<?> getClassFromCache(String className) {
        Object key = JRAbstractJavaCompiler.classCacheKey();
        Map<String, Class<?>> contextMap = classCache.get(key);
        Class<?> cachedClass = null;
        if (contextMap != null) {
            cachedClass = contextMap.get(className);
        }
        return cachedClass;
    }

    protected static synchronized void putClassInCache(String className, Class<?> loadedClass) {
        Object key = JRAbstractJavaCompiler.classCacheKey();
        ReferenceMap contextMap = classCache.get(key);
        if (contextMap == null) {
            contextMap = new ReferenceMap(0, 1);
            classCache.put(key, contextMap);
        }
        contextMap.put((String)className, loadedClass);
    }
}

