/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRReportCompileData;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRStringUtil;

public abstract class JRAbstractCompiler
implements JRCompiler {
    private static final int NAME_SUFFIX_RANDOM_MAX = 1000000;
    private static final Random random = new Random();
    private final boolean needsSourceFiles;

    protected JRAbstractCompiler(boolean needsSourceFiles) {
        this.needsSourceFiles = needsSourceFiles;
    }

    public static String getUnitName(JasperReport report, JRDataset dataset) {
        return JRAbstractCompiler.getUnitName((JRReport)report, dataset, report.getCompileNameSuffix());
    }

    protected static String getUnitName(JRReport report, JRDataset dataset, String nameSuffix) {
        String className = dataset.isMainDataset() ? report.getName() : report.getName() + "_" + dataset.getName();
        className = JRStringUtil.getJavaIdentifier(className) + nameSuffix;
        return className;
    }

    public static String getUnitName(JasperReport report, JRCrosstab crosstab) {
        return JRAbstractCompiler.getUnitName((JRReport)report, crosstab.getId(), report.getCompileNameSuffix());
    }

    protected static String getUnitName(JRReport report, JRCrosstab crosstab, JRExpressionCollector expressionCollector, String nameSuffix) {
        Integer crosstabId = expressionCollector.getCrosstabId(crosstab);
        if (crosstabId == null) {
            throw new JRRuntimeException("Crosstab ID not found.");
        }
        return JRAbstractCompiler.getUnitName(report, crosstabId, nameSuffix);
    }

    protected static String getUnitName(JRReport report, int crosstabId, String nameSuffix) {
        return JRStringUtil.getJavaIdentifier(report.getName()) + "_CROSSTAB" + crosstabId + nameSuffix;
    }

    public final JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        String tempDirStr;
        this.checkLanguage(jasperDesign.getLanguage());
        JRExpressionCollector expressionCollector = JRExpressionCollector.collector(jasperDesign);
        this.verifyDesign(jasperDesign, expressionCollector);
        String nameSuffix = JRAbstractCompiler.createNameSuffix();
        boolean isKeepJavaFile = JRProperties.getBooleanProperty("net.sf.jasperreports.compiler.keep.java.file");
        File tempDirFile = null;
        if (!(!isKeepJavaFile && !this.needsSourceFiles || (tempDirFile = new File(tempDirStr = JRProperties.getProperty("net.sf.jasperreports.compiler.temp.dir"))).exists() && tempDirFile.isDirectory())) {
            throw new JRException("Temporary directory not found : " + tempDirStr);
        }
        List<JRDataset> datasets = jasperDesign.getDatasetsList();
        List<JRCrosstab> crosstabs = jasperDesign.getCrosstabs();
        JRCompilationUnit[] units = new JRCompilationUnit[datasets.size() + crosstabs.size() + 1];
        units[0] = this.createCompileUnit(jasperDesign, jasperDesign.getMainDesignDataset(), expressionCollector, tempDirFile, nameSuffix);
        int sourcesCount = 1;
        for (JRDesignDataset jRDesignDataset : datasets) {
            units[sourcesCount] = this.createCompileUnit(jasperDesign, jRDesignDataset, expressionCollector, tempDirFile, nameSuffix);
            ++sourcesCount;
        }
        for (JRDesignCrosstab jRDesignCrosstab : crosstabs) {
            units[sourcesCount] = this.createCompileUnit(jasperDesign, jRDesignCrosstab, expressionCollector, tempDirFile, nameSuffix);
            ++sourcesCount;
        }
        String classpath = JRProperties.getProperty("net.sf.jasperreports.compiler.classpath");
        try {
            JasperReport jasperReport;
            String string = this.compileUnits(units, classpath, tempDirFile);
            if (string != null) {
                throw new JRException("Errors were encountered when compiling report expressions class file:\n" + string);
            }
            JRReportCompileData reportCompileData = new JRReportCompileData();
            reportCompileData.setMainDatasetCompileData(units[0].getCompileData());
            ListIterator<JRCloneable> it = datasets.listIterator();
            while (it.hasNext()) {
                JRDesignDataset dataset = (JRDesignDataset)it.next();
                reportCompileData.setDatasetCompileData(dataset, units[it.nextIndex()].getCompileData());
            }
            it = crosstabs.listIterator();
            while (it.hasNext()) {
                JRDesignCrosstab crosstab = (JRDesignCrosstab)it.next();
                Integer crosstabId = expressionCollector.getCrosstabId(crosstab);
                reportCompileData.setCrosstabCompileData(crosstabId, units[datasets.size() + it.nextIndex()].getCompileData());
            }
            JasperReport jasperReport2 = jasperReport = new JasperReport((JRReport)jasperDesign, this.getCompilerClass(), (Serializable)reportCompileData, expressionCollector, nameSuffix);
            return jasperReport2;
        }
        catch (JRException jRException) {
            throw jRException;
        }
        catch (Exception exception) {
            throw new JRException("Error compiling report design.", exception);
        }
        finally {
            if (this.needsSourceFiles && !isKeepJavaFile) {
                this.deleteSourceFiles(units);
            }
        }
    }

    private static String createNameSuffix() {
        return "_" + System.currentTimeMillis() + "_" + random.nextInt(1000000);
    }

    protected String getCompilerClass() {
        return this.getClass().getName();
    }

    private void verifyDesign(JasperDesign jasperDesign, JRExpressionCollector expressionCollector) throws JRException {
        Collection<JRValidationFault> brokenRules = JRVerifier.verifyDesign(jasperDesign, expressionCollector);
        if (brokenRules != null && brokenRules.size() > 0) {
            throw new JRValidationException(brokenRules);
        }
    }

    private JRCompilationUnit createCompileUnit(JasperDesign jasperDesign, JRDesignDataset dataset, JRExpressionCollector expressionCollector, File saveSourceDir, String nameSuffix) throws JRException {
        String unitName = JRAbstractCompiler.getUnitName((JRReport)jasperDesign, dataset, nameSuffix);
        JRSourceCompileTask sourceTask = new JRSourceCompileTask(jasperDesign, dataset, expressionCollector, unitName);
        JRCompilationSourceCode sourceCode = this.generateSourceCode(sourceTask);
        File sourceFile = this.getSourceFile(saveSourceDir, unitName, sourceCode);
        return new JRCompilationUnit(unitName, sourceCode, sourceFile, expressionCollector.getExpressions(dataset), sourceTask);
    }

    private JRCompilationUnit createCompileUnit(JasperDesign jasperDesign, JRDesignCrosstab crosstab, JRExpressionCollector expressionCollector, File saveSourceDir, String nameSuffix) throws JRException {
        String unitName = JRAbstractCompiler.getUnitName(jasperDesign, crosstab, expressionCollector, nameSuffix);
        JRSourceCompileTask sourceTask = new JRSourceCompileTask(jasperDesign, crosstab, expressionCollector, unitName);
        JRCompilationSourceCode sourceCode = this.generateSourceCode(sourceTask);
        File sourceFile = this.getSourceFile(saveSourceDir, unitName, sourceCode);
        return new JRCompilationUnit(unitName, sourceCode, sourceFile, expressionCollector.getExpressions(crosstab), sourceTask);
    }

    private File getSourceFile(File saveSourceDir, String unitName, JRCompilationSourceCode sourceCode) throws JRException {
        File sourceFile = null;
        if (saveSourceDir != null && sourceCode != null && sourceCode.getCode() != null) {
            String fileName = this.getSourceFileName(unitName);
            sourceFile = new File(saveSourceDir, fileName);
            JRSaver.saveClassSource(sourceCode.getCode(), sourceFile);
        }
        return sourceFile;
    }

    private void deleteSourceFiles(JRCompilationUnit[] units) {
        for (int i2 = 0; i2 < units.length; ++i2) {
            units[i2].getSourceFile().delete();
        }
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport) throws JRException {
        return this.loadEvaluator(jasperReport, jasperReport.getMainDataset());
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport, JRDataset dataset) throws JRException {
        JRReportCompileData reportCompileData = (JRReportCompileData)jasperReport.getCompileData();
        String unitName = reportCompileData.getUnitName(jasperReport, dataset);
        Serializable compileData = reportCompileData.getDatasetCompileData(dataset);
        return this.loadEvaluator(compileData, unitName);
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport, JRCrosstab crosstab) throws JRException {
        JRReportCompileData reportCompileData = (JRReportCompileData)jasperReport.getCompileData();
        String unitName = reportCompileData.getUnitName(jasperReport, crosstab);
        Serializable compileData = reportCompileData.getCrosstabCompileData(crosstab);
        return this.loadEvaluator(compileData, unitName);
    }

    protected abstract JREvaluator loadEvaluator(Serializable var1, String var2) throws JRException;

    protected abstract void checkLanguage(String var1) throws JRException;

    protected abstract JRCompilationSourceCode generateSourceCode(JRSourceCompileTask var1) throws JRException;

    protected abstract String compileUnits(JRCompilationUnit[] var1, String var2, File var3) throws JRException;

    protected abstract String getSourceFileName(String var1);
}

