/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.type.SortOrderEnum;

public class JRSortableDataSource
implements JRRewindableDataSource {
    private List<Object[]> records = new ArrayList<Object[]>();
    private Iterator<Object[]> iterator;
    private Object[] currentRecord;
    private Map<String, Integer> fieldIndexMap = new HashMap<String, Integer>();
    protected Collator collator;

    public JRSortableDataSource(JRDataSource ds, JRField[] fields, JRSortField[] sortFields, Locale locale) throws JRException {
        if (fields == null) {
            fields = new JRField[]{};
        }
        if (sortFields == null) {
            sortFields = new JRSortField[]{};
        }
        JRSortableDataSource.verifySortFields(fields, sortFields);
        this.collator = Collator.getInstance(locale);
        for (int i2 = 0; i2 < fields.length; ++i2) {
            this.fieldIndexMap.put(fields[i2].getName(), i2);
        }
        int[] sortIndexes = new int[sortFields.length];
        int[] sortOrders = new int[sortFields.length];
        boolean[] collatorFlags = new boolean[sortFields.length];
        block1: for (int i3 = 0; i3 < sortFields.length; ++i3) {
            JRSortField sortField = sortFields[i3];
            sortIndexes[i3] = this.fieldIndexMap.get(sortField.getName());
            sortOrders[i3] = SortOrderEnum.ASCENDING == sortField.getOrderValue() ? 1 : -1;
            collatorFlags[i3] = false;
            for (int j2 = 0; j2 < fields.length; ++j2) {
                JRField field = fields[j2];
                if (!sortField.getName().equals(field.getName())) continue;
                collatorFlags[i3] = String.class.getName().equals(field.getValueClassName());
                continue block1;
            }
        }
        if (ds != null) {
            while (ds.next()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRFillInterruptedException();
                }
                Object[] record = new Object[fields.length];
                for (int i4 = 0; i4 < fields.length; ++i4) {
                    record[i4] = ds.getFieldValue(fields[i4]);
                }
                this.records.add(record);
            }
        }
        Collections.sort(this.records, new DataSourceComparator(sortIndexes, sortOrders, collatorFlags));
        this.iterator = this.records.iterator();
    }

    public boolean next() {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentRecord = this.iterator.next();
        }
        return hasNext;
    }

    public Object getFieldValue(JRField jrField) {
        Integer fieldIndex = this.fieldIndexMap.get(jrField.getName());
        if (fieldIndex == null) {
            throw new JRRuntimeException("Field \"" + jrField.getName() + "\" not found in sortable data source.");
        }
        return this.currentRecord[fieldIndex];
    }

    public void moveFirst() {
        this.iterator = this.records.iterator();
    }

    public static void verifySortFields(JRField[] fields, JRSortField[] sortFields) {
        if (fields != null && sortFields != null) {
            for (int i2 = 0; i2 < sortFields.length; ++i2) {
                String sortFieldName = sortFields[i2].getName();
                boolean isFound = false;
                for (int j2 = 0; !isFound && j2 < fields.length; ++j2) {
                    isFound = sortFieldName.equals(fields[j2].getName());
                }
                if (isFound) continue;
                throw new JRRuntimeException("Sort field \"" + sortFieldName + "\" not found in the list of data source fields.");
            }
        }
    }

    class DataSourceComparator
    implements Comparator {
        int[] sortIndexes = null;
        int[] sortOrders = null;
        boolean[] collatorFlags = null;

        public DataSourceComparator(int[] sortIndexes, int[] sortOrders, boolean[] collatorFlags) {
            this.sortIndexes = sortIndexes;
            this.sortOrders = sortOrders;
            this.collatorFlags = collatorFlags;
        }

        public int compare(Object arg1, Object arg2) {
            Object[] record1 = (Object[])arg1;
            Object[] record2 = (Object[])arg2;
            int ret = 0;
            for (int i2 = 0; i2 < this.sortIndexes.length; ++i2) {
                int sortIndex = this.sortIndexes[i2];
                Comparable field1 = (Comparable)record1[sortIndex];
                Comparable field2 = (Comparable)record2[sortIndex];
                ret = field1 == null ? (field2 == null ? 0 : -1) : (field2 == null ? 1 : (this.collatorFlags[i2] ? JRSortableDataSource.this.collator.compare(field1, field2) : field1.compareTo(field2)));
                if ((ret *= this.sortOrders[i2]) == 0) continue;
                return ret;
            }
            return ret;
        }
    }
}

