/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.Deduplicable;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPenContainer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class JRBasePen
implements JRPen,
Serializable,
Cloneable,
JRChangeEventsSupport,
Deduplicable {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LINE_WIDTH = "lineWidth";
    public static final String PROPERTY_LINE_STYLE = "lineStyle";
    public static final String PROPERTY_LINE_COLOR = "lineColor";
    protected JRPenContainer penContainer;
    protected Float lineWidth;
    protected LineStyleEnum lineStyleValue;
    protected Color lineColor;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 40103;
    private Byte lineStyle;

    public JRBasePen(JRPenContainer penContainer) {
        this.penContainer = penContainer;
    }

    public JRStyleContainer getStyleContainer() {
        return this.penContainer;
    }

    public Float getLineWidth() {
        return JRStyleResolver.getLineWidth(this, this.penContainer.getDefaultLineWidth());
    }

    public Float getOwnLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.setLineWidth(new Float(lineWidth));
    }

    public void setLineWidth(Float lineWidth) {
        Float old = this.lineWidth;
        this.lineWidth = lineWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_WIDTH, old, this.lineWidth);
    }

    public LineStyleEnum getLineStyleValue() {
        return JRStyleResolver.getLineStyleValue(this);
    }

    public LineStyleEnum getOwnLineStyleValue() {
        return this.lineStyleValue;
    }

    public void setLineStyle(LineStyleEnum lineStyleValue) {
        LineStyleEnum old = this.lineStyleValue;
        this.lineStyleValue = lineStyleValue;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_STYLE, old, this.lineStyleValue);
    }

    public Color getLineColor() {
        return JRStyleResolver.getLineColor(this, this.penContainer.getDefaultLineColor());
    }

    public Color getOwnLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        Color old = this.lineColor;
        this.lineColor = lineColor;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_COLOR, old, this.lineColor);
    }

    public String getStyleNameReference() {
        return null;
    }

    public JRPen clone(JRPenContainer penContainer) {
        JRBasePen clone = null;
        try {
            clone = (JRBasePen)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new JRRuntimeException(e2);
        }
        clone.penContainer = penContainer;
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBasePen jRBasePen = this;
        synchronized (jRBasePen) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.lineStyleValue = LineStyleEnum.getByValue(this.lineStyle);
            this.lineStyle = null;
        }
    }

    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        hash.add(this.lineWidth);
        hash.add(this.lineStyleValue);
        hash.add(this.lineColor);
        return hash.getHashCode();
    }

    public boolean isIdentical(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRBasePen)) {
            return false;
        }
        JRBasePen pen = (JRBasePen)object;
        return ObjectUtils.equals(this.lineWidth, pen.lineWidth) && ObjectUtils.equals(this.lineStyleValue, pen.lineStyleValue) && ObjectUtils.equals(this.lineColor, pen.lineColor);
    }
}

