/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseHyperlink
implements JRHyperlink,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String linkType;
    protected String linkTarget;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    protected JRExpression hyperlinkTooltipExpression;
    protected JRHyperlinkParameter[] hyperlinkParameters;
    private byte hyperlinkTarget;

    public JRBaseHyperlink() {
    }

    protected JRBaseHyperlink(JRHyperlink link, JRBaseObjectFactory factory) {
        factory.put(link, this);
        this.linkType = link.getLinkType();
        this.linkTarget = link.getLinkTarget();
        this.hyperlinkReferenceExpression = factory.getExpression(link.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(link.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(link.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(link.getHyperlinkTooltipExpression());
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(link, factory);
    }

    public static JRHyperlinkParameter[] copyHyperlinkParameters(JRHyperlink link, JRBaseObjectFactory factory) {
        JRHyperlinkParameter[] linkParameters = link.getHyperlinkParameters();
        JRHyperlinkParameter[] parameters = null;
        if (linkParameters != null && linkParameters.length > 0) {
            parameters = new JRHyperlinkParameter[linkParameters.length];
            for (int i2 = 0; i2 < linkParameters.length; ++i2) {
                JRHyperlinkParameter parameter = linkParameters[i2];
                parameters[i2] = factory.getHyperlinkParameter(parameter);
            }
        }
        return parameters;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public Object clone() {
        JRBaseHyperlink clone = null;
        try {
            clone = (JRBaseHyperlink)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new JRRuntimeException(e2);
        }
        clone.hyperlinkParameters = (JRHyperlinkParameter[])JRCloneUtils.cloneArray((JRCloneable[])this.hyperlinkParameters);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
    }
}

