/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.base.ElementStore;
import net.sf.jasperreports.engine.base.VirtualElementsData;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.VirtualizationObjectInputStream;
import net.sf.jasperreports.engine.fill.VirtualizationObjectOutputStream;
import net.sf.jasperreports.engine.util.DeepPrintElementCounter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementsBlock
implements JRVirtualizable<VirtualElementsData>,
ElementStore,
Serializable {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(ElementsBlock.class);
    private static final AtomicInteger uidCounter = new AtomicInteger();
    private static final Random uidRandom = new Random();
    private JRVirtualizationContext context;
    private String uid;
    private List<JRPrintElement> elements;
    private transient VirtualElementsData virtualData;
    private transient int deepElementCount;

    public ElementsBlock(JRVirtualizationContext context) {
        this.context = context;
        this.uid = this.makeUID();
        if (log.isDebugEnabled()) {
            log.debug("generated uid " + this.uid + " for " + this);
        }
        this.elements = new ArrayList<JRPrintElement>();
        this.deepElementCount = 0;
    }

    private void register() {
        if (this.context.getVirtualizer() != null) {
            this.context.getVirtualizer().registerObject(this);
        }
    }

    private String makeUID() {
        return System.identityHashCode(this.context) + "_" + System.identityHashCode(this) + "_" + uidCounter.incrementAndGet() + "_" + uidRandom.nextInt();
    }

    @Override
    public int size() {
        this.ensureVirtualData();
        return this.elements.size();
    }

    public boolean isEmpty() {
        this.ensureVirtualData();
        return this.elements.isEmpty();
    }

    @Override
    public JRPrintElement get(int index) {
        this.ensureDataAndTouch();
        return this.elements.get(index);
    }

    protected boolean preAdd(JRPrintElement element, boolean force) {
        int pageSize;
        boolean empty;
        boolean bl = empty = this.elements != null && this.elements.isEmpty();
        if (empty) {
            this.register();
        } else {
            this.ensureDataAndTouch();
        }
        int elementCount = DeepPrintElementCounter.count(element);
        if (!force && !this.elements.isEmpty() && (pageSize = this.context.getPageElementSize()) > 0 && this.deepElementCount + elementCount > pageSize) {
            if (log.isDebugEnabled()) {
                log.debug("overflow of block with size " + this.deepElementCount + ", adding " + elementCount);
            }
            return false;
        }
        this.deepElementCount += elementCount;
        return true;
    }

    public boolean add(JRPrintElement element, boolean force) {
        boolean adding = this.preAdd(element, force);
        if (adding) {
            this.elements.add(element);
        }
        return adding;
    }

    @Override
    public boolean add(JRPrintElement element) {
        return this.add(element, false);
    }

    public boolean add(int index, JRPrintElement element, boolean force) {
        boolean adding = this.preAdd(element, force);
        if (adding) {
            this.elements.add(index, element);
        }
        return adding;
    }

    @Override
    public boolean add(int index, JRPrintElement element) {
        return this.add(index, element, false);
    }

    @Override
    public JRPrintElement set(int index, JRPrintElement element) {
        this.ensureDataAndTouch();
        JRPrintElement oldElement = this.elements.get(index);
        this.deepElementCount -= DeepPrintElementCounter.count(oldElement);
        this.deepElementCount += DeepPrintElementCounter.count(element);
        return this.elements.set(index, element);
    }

    @Override
    public JRPrintElement remove(int index) {
        this.ensureDataAndTouch();
        JRPrintElement element = this.elements.remove(index);
        this.deepElementCount -= DeepPrintElementCounter.count(element);
        if (this.elements.isEmpty()) {
            this.deregister();
        }
        return element;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    private void ensureDataAndTouch() {
        if (this.elements == null) {
            this.ensureData();
        } else if (this.context.getVirtualizer() != null) {
            this.context.getVirtualizer().touch(this);
        }
    }

    @Override
    public void ensureVirtualData() {
        if (this.elements == null) {
            this.ensureData();
        }
    }

    private void ensureData() {
        if (this.context.getVirtualizer() != null) {
            this.context.getVirtualizer().requestData(this);
        }
    }

    @Override
    public void setVirtualData(VirtualElementsData virtualData) {
        this.virtualData = virtualData;
        this.elements = virtualData.getElements();
    }

    @Override
    public VirtualElementsData getVirtualData() {
        return this.virtualData;
    }

    @Override
    public void removeVirtualData() {
        this.virtualData = null;
        this.elements = null;
    }

    @Override
    public void beforeExternalization() {
        this.virtualData = new VirtualElementsData(this.elements);
        this.context.beforeExternalization(this);
    }

    @Override
    public void afterExternalization() {
        this.context.afterExternalization(this);
    }

    @Override
    public void afterInternalization() {
        this.context.afterInternalization(this);
        this.virtualData = null;
    }

    @Override
    public JRVirtualizationContext getContext() {
        return this.context;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String oldUid = (String)in.readObject();
        this.uid = this.makeUID();
        if (log.isDebugEnabled()) {
            log.debug("Original uid " + oldUid + "; new uid " + this.uid);
        }
        this.context = (JRVirtualizationContext)in.readObject();
        int length = in.readInt();
        byte[] buffer = new byte[length];
        in.readFully(buffer);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, buffer.length);
        VirtualizationObjectInputStream elementsStream = new VirtualizationObjectInputStream(inputStream, this.context);
        this.elements = (List)elementsStream.readObject();
        if (!this.elements.isEmpty()) {
            this.register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        this.ensureDataAndTouch();
        this.beforeExternalization();
        try {
            out.writeObject(this.uid);
            out.writeObject(this.context);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            VirtualizationObjectOutputStream stream = new VirtualizationObjectOutputStream(bout, this.context);
            stream.writeObject(this.elements);
            stream.flush();
            byte[] bytes = bout.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }
        finally {
            this.afterExternalization();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    @Override
    public void dispose() {
        if (this.elements == null || !this.elements.isEmpty()) {
            this.deregister();
        }
    }

    private void deregister() {
        if (this.context.getVirtualizer() != null) {
            this.context.getVirtualizer().deregisterObject(this);
        }
    }
}

