/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.xml;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.xml.XmlDataAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDataAdapterService
extends AbstractDataAdapterService {
    public XmlDataAdapterService(XmlDataAdapter xmlDataAdapter) {
        super(xmlDataAdapter);
    }

    public XmlDataAdapter getXmlDataAdapter() {
        return (XmlDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        XmlDataAdapter xmlDataAdapter = this.getXmlDataAdapter();
        if (xmlDataAdapter != null) {
            if (xmlDataAdapter.isUseConnection()) {
                String numberPattern;
                String datePattern;
                TimeZone timeZone;
                Document document = JRXmlUtils.parse(new File(xmlDataAdapter.getFileName()));
                parameters.put("XML_DATA_DOCUMENT", document);
                Locale locale = xmlDataAdapter.getLocale();
                if (locale != null) {
                    parameters.put("XML_LOCALE", locale);
                }
                if ((timeZone = xmlDataAdapter.getTimeZone()) != null) {
                    parameters.put("XML_TIME_ZONE", timeZone);
                }
                if ((datePattern = xmlDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                    parameters.put("XML_DATE_PATTERN", datePattern);
                }
                if ((numberPattern = xmlDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                    parameters.put("XML_NUMBER_PATTERN", numberPattern);
                }
            } else {
                String numberPattern;
                String datePattern;
                TimeZone timeZone;
                JRXmlDataSource ds = new JRXmlDataSource(xmlDataAdapter.getFileName(), xmlDataAdapter.getSelectExpression());
                Locale locale = xmlDataAdapter.getLocale();
                if (locale != null) {
                    ds.setLocale(locale);
                }
                if ((timeZone = xmlDataAdapter.getTimeZone()) != null) {
                    ds.setTimeZone(timeZone);
                }
                if ((datePattern = xmlDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                    ds.setDatePattern(datePattern);
                }
                if ((numberPattern = xmlDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                    ds.setNumberPattern(numberPattern);
                }
                parameters.put("REPORT_DATA_SOURCE", ds);
            }
        }
    }
}

