/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.provider;

import java.util.Map;
import net.sf.jasperreports.data.AbstractClasspathAwareDataAdapterService;
import net.sf.jasperreports.data.provider.DataSourceProviderDataAdapter;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.CompositeClassloader;
import net.sf.jasperreports.engine.util.JRClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceProviderDataAdapterService
extends AbstractClasspathAwareDataAdapterService {
    private JRDataSourceProvider provider = null;

    public DataSourceProviderDataAdapterService(DataSourceProviderDataAdapter dsDataAdapter) {
        super(dsDataAdapter);
    }

    public DataSourceProviderDataAdapter getDataSourceProviderDataAdapter() {
        return (DataSourceProviderDataAdapter)this.getDataAdapter();
    }

    public JRDataSourceProvider getProvider() throws JRException {
        DataSourceProviderDataAdapter dsDataAdapter;
        if (this.provider == null && (dsDataAdapter = this.getDataSourceProviderDataAdapter()) != null) {
            ClassLoader oldThreadClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(new CompositeClassloader(this.getClassLoader(), oldThreadClassLoader));
                Class<?> clazz = JRClassLoader.loadClassForRealName(dsDataAdapter.getProviderClass());
                this.provider = (JRDataSourceProvider)clazz.newInstance();
            }
            catch (ClassNotFoundException e2) {
                throw new JRException(e2);
            }
            catch (IllegalAccessException e3) {
                throw new JRException(e3);
            }
            catch (InstantiationException e4) {
                throw new JRException(e4);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldThreadClassLoader);
            }
        }
        return this.provider;
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        JRDataSourceProvider dsProvider = this.getProvider();
        if (dsProvider != null) {
            parameters.put("REPORT_DATA_SOURCE", dsProvider.create(null));
        }
    }
}

