/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.bean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import net.sf.jasperreports.data.AbstractClasspathAwareDataAdapterService;
import net.sf.jasperreports.data.bean.BeanDataAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.CompositeClassloader;
import net.sf.jasperreports.engine.util.JRClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDataAdapterService
extends AbstractClasspathAwareDataAdapterService {
    public BeanDataAdapterService(BeanDataAdapter beanDataAdapter) {
        super(beanDataAdapter);
    }

    public BeanDataAdapter getBeanDataAdapter() {
        return (BeanDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        BeanDataAdapter beanDataAdapter = this.getBeanDataAdapter();
        if (beanDataAdapter != null) {
            JRAbstractBeanDataSource beanDataSource;
            block13: {
                beanDataSource = null;
                ClassLoader oldThreadClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(new CompositeClassloader(this.getClassLoader(), oldThreadClassLoader));
                    Class<?> clazz = JRClassLoader.loadClassForRealName(beanDataAdapter.getFactoryClass());
                    Method method = clazz.getMethod(beanDataAdapter.getMethodName(), new Class[0]);
                    Object res = method.invoke(null, new Object[0]);
                    if (res instanceof Collection) {
                        beanDataSource = new JRBeanCollectionDataSource((Collection)res, beanDataAdapter.isUseFieldDescription());
                        break block13;
                    }
                    if (res instanceof Object[]) {
                        beanDataSource = new JRBeanArrayDataSource((Object[])res, beanDataAdapter.isUseFieldDescription());
                        break block13;
                    }
                    throw new JRException("Factory method must return Collection<?> or Object[] not: " + clazz.getName());
                }
                catch (ClassNotFoundException e2) {
                    throw new JRException(e2);
                }
                catch (IllegalAccessException e3) {
                    throw new JRException(e3);
                }
                catch (SecurityException e4) {
                    throw new JRException(e4);
                }
                catch (NoSuchMethodException e5) {
                    throw new JRException(e5);
                }
                catch (IllegalArgumentException e6) {
                    throw new JRException(e6);
                }
                catch (InvocationTargetException e7) {
                    throw new JRException(e7);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldThreadClassLoader);
                }
            }
            parameters.put("REPORT_DATA_SOURCE", beanDataSource);
        }
    }
}

