/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.design;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstab;
import net.sf.jasperreports.crosstabs.design.JRCrosstabOrigin;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.collections.SequencedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRDesignCrosstab
extends JRDesignElement
implements JRCrosstab {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_COLUMN_BREAK_OFFSET = "columnBreakOffset";
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_HEADER_CELL = "headerCell";
    public static final String PROPERTY_PARAMETERS_MAP_EXPRESSION = "parametersMapExpression";
    public static final String PROPERTY_REPEAT_COLUMN_HEADERS = "repeatColumnHeaders";
    public static final String PROPERTY_REPEAT_ROW_HEADERS = "repeatRowHeaders";
    public static final String PROPERTY_WHEN_NO_DATA_CELL = "whenNoDataCell";
    public static final String PROPERTY_CELLS = "cells";
    public static final String PROPERTY_ROW_GROUPS = "rowGroups";
    public static final String PROPERTY_COLUMN_GROUPS = "columnGroups";
    public static final String PROPERTY_MEASURES = "measures";
    public static final String PROPERTY_PARAMETERS = "parameters";
    public static final String PROPERTY_IGNORE_WIDTH = "ignoreWidth";
    protected List<JRCrosstabParameter> parametersList;
    protected Map<String, JRCrosstabParameter> parametersMap;
    protected SequencedHashMap variablesList;
    protected JRExpression parametersMapExpression;
    protected JRDesignCrosstabDataset dataset;
    protected List<JRCrosstabRowGroup> rowGroups;
    protected List<JRCrosstabColumnGroup> columnGroups;
    protected List<JRCrosstabMeasure> measures;
    protected Map<String, Integer> rowGroupsMap;
    protected Map<String, Integer> columnGroupsMap;
    protected Map<String, Integer> measuresMap;
    protected int columnBreakOffset = 10;
    protected boolean repeatColumnHeaders = true;
    protected boolean repeatRowHeaders = true;
    protected RunDirectionEnum runDirectionValue;
    protected List<JRCrosstabCell> cellsList;
    protected Map<Pair, JRCrosstabCell> cellsMap;
    protected JRDesignCrosstabCell[][] crossCells;
    protected JRDesignCellContents whenNoDataCell;
    protected JRDesignCellContents headerCell;
    protected Boolean ignoreWidth;
    protected JRLineBox lineBox;
    private PropertyChangeListener measureClassChangeListener = new MeasureClassChangeListener();
    private static final Object[] BUILT_IN_PARAMETERS = new Object[]{"REPORT_CONTEXT", ReportContext.class, "REPORT_PARAMETERS_MAP", Map.class, "REPORT_LOCALE", Locale.class, "REPORT_RESOURCE_BUNDLE", ResourceBundle.class, "REPORT_TIME_ZONE", TimeZone.class, "REPORT_FORMAT_FACTORY", FormatFactory.class, "REPORT_CLASS_LOADER", ClassLoader.class, "REPORT_URL_HANDLER_FACTORY", URLStreamHandlerFactory.class, "REPORT_FILE_RESOLVER", FileResolver.class};
    private static final Object[] BUILT_IN_VARIABLES = new Object[]{"ROW_COUNT", Integer.class, "COLUMN_COUNT", Integer.class};
    private int PSEUDO_SERIAL_VERSION_UID = 40103;
    private byte runDirection;

    public JRDesignCrosstab(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
        this.parametersList = new ArrayList<JRCrosstabParameter>();
        this.parametersMap = new HashMap<String, JRCrosstabParameter>();
        this.rowGroupsMap = new HashMap<String, Integer>();
        this.rowGroups = new ArrayList<JRCrosstabRowGroup>();
        this.columnGroupsMap = new HashMap<String, Integer>();
        this.columnGroups = new ArrayList<JRCrosstabColumnGroup>();
        this.measuresMap = new HashMap<String, Integer>();
        this.measures = new ArrayList<JRCrosstabMeasure>();
        this.cellsMap = new HashMap<Pair, JRCrosstabCell>();
        this.cellsList = new ArrayList<JRCrosstabCell>();
        this.addBuiltinParameters();
        this.variablesList = new SequencedHashMap();
        this.addBuiltinVariables();
        this.dataset = new JRDesignCrosstabDataset();
        this.lineBox = new JRBaseLineBox(this);
    }

    private void addBuiltinParameters() {
        for (int i2 = 0; i2 < BUILT_IN_PARAMETERS.length; ++i2) {
            JRDesignCrosstabParameter parameter = new JRDesignCrosstabParameter();
            parameter.setName((String)BUILT_IN_PARAMETERS[i2++]);
            parameter.setValueClass((Class)BUILT_IN_PARAMETERS[i2]);
            parameter.setSystemDefined(true);
            try {
                this.addParameter(parameter);
                continue;
            }
            catch (JRException jRException) {
                // empty catch block
            }
        }
    }

    private void addBuiltinVariables() {
        for (int i2 = 0; i2 < BUILT_IN_VARIABLES.length; ++i2) {
            JRDesignVariable variable = new JRDesignVariable();
            variable.setName((String)BUILT_IN_VARIABLES[i2]);
            variable.setValueClass((Class)BUILT_IN_VARIABLES[++i2]);
            variable.setCalculation(CalculationEnum.SYSTEM);
            variable.setSystemDefined(true);
            this.addVariable(variable);
        }
    }

    public JRDesignCrosstab() {
        this(null);
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    public JRDesignCrosstabDataset getDesignDataset() {
        return this.dataset;
    }

    @Override
    public JRCrosstabRowGroup[] getRowGroups() {
        JRCrosstabRowGroup[] groups = new JRCrosstabRowGroup[this.rowGroups.size()];
        this.rowGroups.toArray(groups);
        return groups;
    }

    @Override
    public JRCrosstabColumnGroup[] getColumnGroups() {
        JRCrosstabColumnGroup[] groups = new JRCrosstabColumnGroup[this.columnGroups.size()];
        this.columnGroups.toArray(groups);
        return groups;
    }

    @Override
    public JRCrosstabMeasure[] getMeasures() {
        JRCrosstabMeasure[] measureArray = new JRCrosstabMeasure[this.measures.size()];
        this.measures.toArray(measureArray);
        return measureArray;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitCrosstab(this);
    }

    public void setDataset(JRDesignCrosstabDataset dataset) {
        JRDesignCrosstabDataset old = this.dataset;
        this.dataset = dataset;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET, old, this.dataset);
    }

    public void addRowGroup(JRDesignCrosstabRowGroup group) throws JRException {
        String groupName = group.getName();
        if (this.rowGroupsMap.containsKey(groupName) || this.columnGroupsMap.containsKey(groupName) || this.measuresMap.containsKey(groupName)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.rowGroupsMap.put(groupName, this.rowGroups.size());
        this.rowGroups.add(group);
        this.addRowGroupVars(group);
        this.setParent(group);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_ROW_GROUPS, group, this.rowGroups.size() - 1);
    }

    public void addRowGroup(int index, JRDesignCrosstabRowGroup group) throws JRException {
        String groupName = group.getName();
        if (this.rowGroupsMap.containsKey(groupName) || this.columnGroupsMap.containsKey(groupName) || this.measuresMap.containsKey(groupName)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.rowGroupsMap.put(groupName, this.rowGroups.size());
        this.rowGroups.add(index, group);
        this.addRowGroupVars(group);
        this.setParent(group);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_ROW_GROUPS, group, index);
    }

    protected void addRowGroupVars(JRDesignCrosstabRowGroup rowGroup) {
        this.addVariable(rowGroup.getVariable());
        for (JRCrosstabMeasure measure : this.measures) {
            this.addTotalVar(measure, rowGroup, null);
            for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
                this.addTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public void addColumnGroup(JRDesignCrosstabColumnGroup group) throws JRException {
        String groupName = group.getName();
        if (this.rowGroupsMap.containsKey(groupName) || this.columnGroupsMap.containsKey(groupName) || this.measuresMap.containsKey(groupName)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.columnGroupsMap.put(groupName, this.columnGroups.size());
        this.columnGroups.add(group);
        this.addColGroupVars(group);
        this.setParent(group);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_COLUMN_GROUPS, group, this.columnGroups.size() - 1);
    }

    public void addColumnGroup(int index, JRDesignCrosstabColumnGroup group) throws JRException {
        String groupName = group.getName();
        if (this.rowGroupsMap.containsKey(groupName) || this.columnGroupsMap.containsKey(groupName) || this.measuresMap.containsKey(groupName)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.columnGroupsMap.put(groupName, this.columnGroups.size());
        this.columnGroups.add(index, group);
        this.addColGroupVars(group);
        this.setParent(group);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_COLUMN_GROUPS, group, index);
    }

    protected void addColGroupVars(JRDesignCrosstabColumnGroup colGroup) {
        this.addVariable(colGroup.getVariable());
        for (JRCrosstabMeasure measure : this.measures) {
            this.addTotalVar(measure, null, colGroup);
            for (JRCrosstabRowGroup rowGroup : this.rowGroups) {
                this.addTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public void addMeasure(JRDesignCrosstabMeasure measure) throws JRException {
        String measureName = measure.getName();
        if (this.rowGroupsMap.containsKey(measureName) || this.columnGroupsMap.containsKey(measureName) || this.measuresMap.containsKey(measureName)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        measure.addPropertyChangeListener("valueClassName", this.measureClassChangeListener);
        this.measuresMap.put(measureName, this.measures.size());
        this.measures.add(measure);
        this.addMeasureVars(measure);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MEASURES, measure, this.measures.size() - 1);
    }

    public void addMeasure(int index, JRDesignCrosstabMeasure measure) throws JRException {
        String measureName = measure.getName();
        if (this.rowGroupsMap.containsKey(measureName) || this.columnGroupsMap.containsKey(measureName) || this.measuresMap.containsKey(measureName)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        measure.addPropertyChangeListener("valueClassName", this.measureClassChangeListener);
        this.measuresMap.put(measureName, this.measures.size());
        this.measures.add(index, measure);
        this.addMeasureVars(measure);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MEASURES, measure, index);
    }

    protected void addMeasureVars(JRDesignCrosstabMeasure measure) {
        this.addVariable(measure.getVariable());
        for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
            this.addTotalVar(measure, null, colGroup);
        }
        for (JRCrosstabRowGroup rowGroup : this.rowGroups) {
            this.addTotalVar(measure, rowGroup, null);
            for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
                this.addTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    protected void addTotalVar(JRCrosstabMeasure measure, JRCrosstabRowGroup rowGroup, JRCrosstabColumnGroup colGroup) {
        JRDesignVariable var = new JRDesignVariable();
        var.setCalculation(CalculationEnum.SYSTEM);
        var.setSystemDefined(true);
        var.setName(JRDesignCrosstab.getTotalVariableName(measure, rowGroup, colGroup));
        var.setValueClassName(measure.getValueClassName());
        this.addVariable(var);
    }

    protected void removeTotalVar(JRCrosstabMeasure measure, JRCrosstabRowGroup rowGroup, JRCrosstabColumnGroup colGroup) {
        String varName = JRDesignCrosstab.getTotalVariableName(measure, rowGroup, colGroup);
        this.removeVariable(varName);
    }

    public static String getTotalVariableName(JRCrosstabMeasure measure, JRCrosstabRowGroup rowGroup, JRCrosstabColumnGroup colGroup) {
        StringBuffer name = new StringBuffer();
        name.append(measure.getName());
        if (rowGroup != null) {
            name.append('_');
            name.append(rowGroup.getName());
        }
        if (colGroup != null) {
            name.append('_');
            name.append(colGroup.getName());
        }
        name.append("_ALL");
        return name.toString();
    }

    public JRCrosstabRowGroup removeRowGroup(String groupName) {
        JRCrosstabRowGroup removed = null;
        Integer idx = this.rowGroupsMap.remove(groupName);
        if (idx != null) {
            removed = this.rowGroups.remove(idx);
            Iterator<JRCloneable> it = this.rowGroups.listIterator(idx);
            while (it.hasNext()) {
                JRCrosstabRowGroup group = it.next();
                this.rowGroupsMap.put(group.getName(), it.previousIndex());
            }
            it = this.cellsList.iterator();
            while (it.hasNext()) {
                JRCrosstabCell cell = (JRCrosstabCell)it.next();
                String rowTotalGroup = cell.getRowTotalGroup();
                if (rowTotalGroup == null || !rowTotalGroup.equals(groupName)) continue;
                it.remove();
                this.cellsMap.remove(new Pair<String, String>(rowTotalGroup, cell.getColumnTotalGroup()));
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CELLS, cell, -1);
            }
            this.removeRowGroupVars(removed);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_ROW_GROUPS, removed, idx);
        }
        return removed;
    }

    protected void removeRowGroupVars(JRCrosstabRowGroup rowGroup) {
        this.removeVariable(rowGroup.getVariable());
        for (JRCrosstabMeasure measure : this.measures) {
            this.removeTotalVar(measure, rowGroup, null);
            for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
                this.removeTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public JRCrosstabRowGroup removeRowGroup(JRCrosstabRowGroup group) {
        return this.removeRowGroup(group.getName());
    }

    public JRCrosstabColumnGroup removeColumnGroup(String groupName) {
        JRCrosstabColumnGroup removed = null;
        Integer idx = this.columnGroupsMap.remove(groupName);
        if (idx != null) {
            removed = this.columnGroups.remove(idx);
            Iterator<JRCloneable> it = this.columnGroups.listIterator(idx);
            while (it.hasNext()) {
                JRCrosstabColumnGroup group = it.next();
                this.columnGroupsMap.put(group.getName(), it.previousIndex());
            }
            it = this.cellsList.iterator();
            while (it.hasNext()) {
                JRCrosstabCell cell = (JRCrosstabCell)it.next();
                String columnTotalGroup = cell.getColumnTotalGroup();
                if (columnTotalGroup == null || !columnTotalGroup.equals(groupName)) continue;
                it.remove();
                this.cellsMap.remove(new Pair<String, String>(cell.getRowTotalGroup(), columnTotalGroup));
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CELLS, cell, -1);
            }
            this.removeColGroupVars(removed);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_COLUMN_GROUPS, removed, idx);
        }
        return removed;
    }

    protected void removeColGroupVars(JRCrosstabColumnGroup colGroup) {
        this.removeVariable(colGroup.getVariable());
        for (JRCrosstabMeasure measure : this.measures) {
            this.removeTotalVar(measure, null, colGroup);
            for (JRCrosstabRowGroup rowGroup : this.rowGroups) {
                this.removeTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public JRCrosstabColumnGroup removeColumnGroup(JRCrosstabColumnGroup group) {
        return this.removeColumnGroup(group.getName());
    }

    public JRCrosstabMeasure removeMeasure(String measureName) {
        JRDesignCrosstabMeasure removed = null;
        Integer idx = this.measuresMap.remove(measureName);
        if (idx != null) {
            removed = (JRDesignCrosstabMeasure)this.measures.remove(idx);
            ListIterator<JRCrosstabMeasure> it = this.measures.listIterator(idx);
            while (it.hasNext()) {
                JRCrosstabMeasure group = it.next();
                this.measuresMap.put(group.getName(), it.previousIndex());
            }
            this.removeMeasureVars(removed);
            removed.removePropertyChangeListener("valueClassName", this.measureClassChangeListener);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_MEASURES, removed, idx);
        }
        return removed;
    }

    protected void removeMeasureVars(JRDesignCrosstabMeasure measure) {
        this.removeVariable(measure.getVariable());
        for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
            this.removeTotalVar(measure, null, colGroup);
        }
        for (JRCrosstabRowGroup rowGroup : this.rowGroups) {
            this.removeTotalVar(measure, rowGroup, null);
            for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
                this.removeTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public JRCrosstabMeasure removeMeasure(JRCrosstabMeasure measure) {
        return this.removeMeasure(measure.getName());
    }

    @Override
    public boolean isRepeatColumnHeaders() {
        return this.repeatColumnHeaders;
    }

    public void setRepeatColumnHeaders(boolean repeatColumnHeaders) {
        boolean old = this.repeatColumnHeaders;
        this.repeatColumnHeaders = repeatColumnHeaders;
        this.getEventSupport().firePropertyChange(PROPERTY_REPEAT_COLUMN_HEADERS, old, this.repeatColumnHeaders);
    }

    @Override
    public boolean isRepeatRowHeaders() {
        return this.repeatRowHeaders;
    }

    public void setRepeatRowHeaders(boolean repeatRowHeaders) {
        boolean old = this.repeatRowHeaders;
        this.repeatRowHeaders = repeatRowHeaders;
        this.getEventSupport().firePropertyChange(PROPERTY_REPEAT_ROW_HEADERS, old, this.repeatRowHeaders);
    }

    @Override
    public JRCrosstabCell[][] getCells() {
        return this.crossCells;
    }

    public List<JRCrosstabCell> getCellsList() {
        return this.cellsList;
    }

    public Map<Pair, JRCrosstabCell> getCellsMap() {
        return this.cellsMap;
    }

    public void addCell(JRDesignCrosstabCell cell) throws JRException {
        String rowTotalGroup = cell.getRowTotalGroup();
        if (rowTotalGroup != null && !this.rowGroupsMap.containsKey(rowTotalGroup)) {
            throw new JRException("Row group " + rowTotalGroup + " does not exist.");
        }
        String columnTotalGroup = cell.getColumnTotalGroup();
        if (columnTotalGroup != null && !this.columnGroupsMap.containsKey(columnTotalGroup)) {
            throw new JRException("Row group " + columnTotalGroup + " does not exist.");
        }
        Pair<String, String> cellKey = new Pair<String, String>(rowTotalGroup, columnTotalGroup);
        if (this.cellsMap.containsKey(cellKey)) {
            throw new JRException("Duplicate cell in crosstab.");
        }
        this.cellsMap.put(cellKey, cell);
        this.cellsList.add(cell);
        this.setCellOrigin(cell.getContents(), new JRCrosstabOrigin(this, 7, rowTotalGroup, columnTotalGroup));
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CELLS, cell, this.cellsList.size() - 1);
    }

    public JRCrosstabCell removeCell(String rowTotalGroup, String columnTotalGroup) {
        Pair<String, String> cellKey = new Pair<String, String>(rowTotalGroup, columnTotalGroup);
        JRCrosstabCell cell = this.cellsMap.remove(cellKey);
        if (cell != null) {
            this.cellsList.remove(cell);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CELLS, cell, -1);
        }
        return cell;
    }

    public JRCrosstabCell removeCell(JRCrosstabCell cell) {
        return this.removeCell(cell.getRowTotalGroup(), cell.getColumnTotalGroup());
    }

    @Override
    public JRCrosstabParameter[] getParameters() {
        JRCrosstabParameter[] parameters = new JRCrosstabParameter[this.parametersList.size()];
        this.parametersList.toArray(parameters);
        return parameters;
    }

    public List<JRCrosstabParameter> getParametersList() {
        return this.parametersList;
    }

    public Map<String, JRCrosstabParameter> getParametersMap() {
        return this.parametersMap;
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public void addParameter(JRCrosstabParameter parameter) throws JRException {
        if (this.parametersMap.containsKey(parameter.getName()) && this.parametersMap.containsKey(parameter.getName())) {
            throw new JRException("Duplicate declaration of parameter : " + parameter.getName());
        }
        this.parametersMap.put(parameter.getName(), parameter);
        this.parametersList.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, parameter, this.parametersList.size() - 1);
    }

    public void addParameter(int index, JRCrosstabParameter parameter) throws JRException {
        if (this.parametersMap.containsKey(parameter.getName()) && this.parametersMap.containsKey(parameter.getName())) {
            throw new JRException("Duplicate declaration of parameter : " + parameter.getName());
        }
        this.parametersMap.put(parameter.getName(), parameter);
        this.parametersList.add(index, parameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, parameter, index);
    }

    public JRCrosstabParameter removeParameter(String parameterName) {
        JRCrosstabParameter param = this.parametersMap.remove(parameterName);
        if (param != null) {
            int idx = this.parametersList.indexOf(param);
            if (idx >= 0) {
                this.parametersList.remove(idx);
            }
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, param, idx);
        }
        return param;
    }

    public JRCrosstabParameter removeParameter(JRCrosstabParameter parameter) {
        return this.removeParameter(parameter.getName());
    }

    public void setParametersMapExpression(JRExpression expression) {
        JRExpression old = this.parametersMapExpression;
        this.parametersMapExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_PARAMETERS_MAP_EXPRESSION, old, this.parametersMapExpression);
    }

    public Map<String, JRVariable> getVariablesMap() {
        JRVariable[] variables = this.getVariables();
        HashMap<String, JRVariable> variablesMap = new HashMap<String, JRVariable>();
        for (int i2 = 0; i2 < variables.length; ++i2) {
            variablesMap.put(variables[i2].getName(), variables[i2]);
        }
        return variablesMap;
    }

    @Override
    public JRVariable[] getVariables() {
        JRVariable[] variables = new JRVariable[this.variablesList.size()];
        this.variablesList.values().toArray(variables);
        return variables;
    }

    @Override
    public int getColumnBreakOffset() {
        return this.columnBreakOffset;
    }

    public void setColumnBreakOffset(int columnBreakOffset) {
        int old = this.columnBreakOffset;
        this.columnBreakOffset = columnBreakOffset;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_BREAK_OFFSET, old, this.columnBreakOffset);
    }

    public void preprocess() {
        this.setGroupVariablesClass(this.rowGroups);
        this.setGroupVariablesClass(this.columnGroups);
        this.calculateSizes();
    }

    protected <T> void setGroupVariablesClass(List<T> groups) {
        for (JRDesignCrosstabGroup group : groups) {
            JRExpression expression;
            JRCrosstabBucket bucket = group.getBucket();
            if (bucket == null || (expression = bucket.getExpression()) == null) continue;
            group.designVariable.setValueClassName(bucket.getValueClassName());
        }
    }

    protected void calculateSizes() {
        this.setWhenNoDataCellSize();
        this.createCellMatrix();
        int rowHeadersWidth = this.calculateRowHeadersSizes();
        int colHeadersHeight = this.calculateColumnHeadersSizes();
        if (this.headerCell != null) {
            this.headerCell.setWidth(rowHeadersWidth);
            this.headerCell.setHeight(colHeadersHeight);
        }
    }

    protected void setWhenNoDataCellSize() {
        if (this.whenNoDataCell != null) {
            this.whenNoDataCell.setWidth(this.getWidth());
            this.whenNoDataCell.setHeight(this.getHeight());
        }
    }

    protected void createCellMatrix() {
        this.crossCells = new JRDesignCrosstabCell[this.rowGroups.size() + 1][this.columnGroups.size() + 1];
        for (JRDesignCrosstabCell jRDesignCrosstabCell : this.cellsList) {
            String columnTotalGroup;
            JRDesignCellContents contents = (JRDesignCellContents)jRDesignCrosstabCell.getContents();
            String rowTotalGroup = jRDesignCrosstabCell.getRowTotalGroup();
            int rowGroupIndex = rowTotalGroup == null ? this.rowGroups.size() : this.rowGroupsMap.get(rowTotalGroup).intValue();
            Integer cellWidth = jRDesignCrosstabCell.getWidth();
            if (cellWidth != null) {
                contents.setWidth(cellWidth);
            }
            int columnGroupIndex = (columnTotalGroup = jRDesignCrosstabCell.getColumnTotalGroup()) == null ? this.columnGroups.size() : this.columnGroupsMap.get(columnTotalGroup).intValue();
            Integer cellHeight = jRDesignCrosstabCell.getHeight();
            if (cellHeight != null) {
                contents.setHeight(cellHeight);
            }
            this.crossCells[rowGroupIndex][columnGroupIndex] = jRDesignCrosstabCell;
        }
        this.inheritCells();
    }

    protected JRDesignCrosstabRowGroup getRowGroup(int rowGroupIndex) {
        return (JRDesignCrosstabRowGroup)this.rowGroups.get(rowGroupIndex);
    }

    protected JRDesignCrosstabColumnGroup getColumnGroup(int columnGroupIndex) {
        return (JRDesignCrosstabColumnGroup)this.columnGroups.get(columnGroupIndex);
    }

    protected void inheritCells() {
        for (int i2 = this.rowGroups.size(); i2 >= 0; --i2) {
            for (int j2 = this.columnGroups.size(); j2 >= 0; --j2) {
                boolean used;
                boolean bl = used = !(i2 != this.rowGroups.size() && !this.getRowGroup(i2).hasTotal() || j2 != this.columnGroups.size() && !this.getColumnGroup(j2).hasTotal());
                if (used) {
                    if (this.crossCells[i2][j2] == null) {
                        this.inheritCell(i2, j2);
                        if (this.crossCells[i2][j2] != null) continue;
                        this.crossCells[i2][j2] = this.emptyCell(i2, j2);
                        this.inheritCellSize(i2, j2);
                        continue;
                    }
                    this.inheritCellSize(i2, j2);
                    continue;
                }
                this.crossCells[i2][j2] = null;
            }
        }
    }

    private JRDesignCrosstabCell emptyCell(int i2, int j2) {
        JRDesignCrosstabCell emptyCell = new JRDesignCrosstabCell();
        if (i2 < this.rowGroups.size()) {
            emptyCell.setRowTotalGroup(this.rowGroups.get(i2).getName());
        }
        if (j2 < this.columnGroups.size()) {
            emptyCell.setColumnTotalGroup(this.columnGroups.get(j2).getName());
        }
        return emptyCell;
    }

    protected void inheritCellSize(int i2, int j2) {
        JRDesignCellContents contents;
        block6: {
            block7: {
                JRDesignCrosstabCell cell = this.crossCells[i2][j2];
                contents = (JRDesignCellContents)cell.getContents();
                if (contents.getWidth() != Integer.MIN_VALUE) break block6;
                if (i2 >= this.rowGroups.size()) break block7;
                JRDesignCrosstabCell rowCell = this.crossCells[this.rowGroups.size()][j2];
                if (rowCell == null) break block6;
                contents.setWidth(rowCell.getContents().getWidth());
                break block6;
            }
            for (int k2 = j2 + 1; k2 <= this.columnGroups.size(); ++k2) {
                if (this.crossCells[i2][k2] == null) continue;
                contents.setWidth(this.crossCells[i2][k2].getContents().getWidth());
                break;
            }
        }
        if (contents.getHeight() == Integer.MIN_VALUE) {
            if (j2 < this.columnGroups.size()) {
                JRDesignCrosstabCell colCell = this.crossCells[i2][this.columnGroups.size()];
                if (colCell != null) {
                    contents.setHeight(colCell.getContents().getHeight());
                }
            } else {
                for (int k3 = i2 + 1; k3 <= this.rowGroups.size(); ++k3) {
                    if (this.crossCells[k3][j2] == null) continue;
                    contents.setHeight(this.crossCells[k3][j2].getContents().getHeight());
                }
            }
        }
    }

    protected void inheritCell(int i2, int j2) {
        JRDesignCellContents contents;
        JRDesignCrosstabCell cell;
        int k2;
        JRDesignCrosstabCell inheritedCell = null;
        if (j2 < this.columnGroups.size()) {
            JRDesignCrosstabCell colCell = this.crossCells[this.rowGroups.size()][j2];
            JRDesignCellContents colContents = colCell == null ? null : (JRDesignCellContents)colCell.getContents();
            for (k2 = j2 + 1; inheritedCell == null && k2 <= this.columnGroups.size(); ++k2) {
                cell = this.crossCells[i2][k2];
                if (cell == null) continue;
                contents = (JRDesignCellContents)cell.getContents();
                if (colContents != null && contents.getWidth() != colContents.getWidth()) continue;
                inheritedCell = cell;
            }
        }
        if (inheritedCell == null && i2 < this.rowGroups.size()) {
            JRDesignCrosstabCell rowCell = this.crossCells[i2][this.columnGroups.size()];
            JRDesignCellContents rowContents = rowCell == null ? null : (JRDesignCellContents)rowCell.getContents();
            for (k2 = i2 + 1; inheritedCell == null && k2 <= this.rowGroups.size(); ++k2) {
                cell = this.crossCells[k2][j2];
                if (cell == null) continue;
                contents = (JRDesignCellContents)cell.getContents();
                if (rowContents != null && contents.getHeight() != rowContents.getHeight()) continue;
                inheritedCell = cell;
            }
        }
        this.crossCells[i2][j2] = inheritedCell;
    }

    protected int calculateRowHeadersSizes() {
        int widthSum = 0;
        int heightSum = 0;
        for (int i2 = this.rowGroups.size() - 1; i2 >= 0; --i2) {
            JRDesignCrosstabRowGroup group = (JRDesignCrosstabRowGroup)this.rowGroups.get(i2);
            widthSum += group.getWidth();
            JRDesignCrosstabCell cell = this.crossCells[i2 + 1][this.columnGroups.size()];
            if (cell != null) {
                heightSum += cell.getContents().getHeight();
            }
            JRDesignCellContents header = (JRDesignCellContents)group.getHeader();
            header.setHeight(heightSum);
            header.setWidth(group.getWidth());
            if (!group.hasTotal()) continue;
            JRDesignCellContents totalHeader = (JRDesignCellContents)group.getTotalHeader();
            totalHeader.setWidth(widthSum);
            JRDesignCrosstabCell totalCell = this.crossCells[i2][this.columnGroups.size()];
            if (totalCell == null) continue;
            totalHeader.setHeight(totalCell.getContents().getHeight());
        }
        return widthSum;
    }

    protected int calculateColumnHeadersSizes() {
        int heightSum = 0;
        int widthSum = 0;
        for (int i2 = this.columnGroups.size() - 1; i2 >= 0; --i2) {
            JRDesignCrosstabColumnGroup group = (JRDesignCrosstabColumnGroup)this.columnGroups.get(i2);
            heightSum += group.getHeight();
            JRDesignCrosstabCell cell = this.crossCells[this.rowGroups.size()][i2 + 1];
            if (cell != null) {
                widthSum += cell.getContents().getWidth();
            }
            JRDesignCellContents header = (JRDesignCellContents)group.getHeader();
            header.setHeight(group.getHeight());
            header.setWidth(widthSum);
            if (!group.hasTotal()) continue;
            JRDesignCellContents totalHeader = (JRDesignCellContents)group.getTotalHeader();
            totalHeader.setHeight(heightSum);
            JRDesignCrosstabCell totalCell = this.crossCells[this.rowGroups.size()][i2];
            if (totalCell == null) continue;
            totalHeader.setWidth(totalCell.getContents().getWidth());
        }
        return heightSum;
    }

    @Override
    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public void setWhenNoDataCell(JRDesignCellContents whenNoDataCell) {
        JRDesignCellContents old = this.whenNoDataCell;
        this.whenNoDataCell = whenNoDataCell;
        this.setCellOrigin(this.whenNoDataCell, new JRCrosstabOrigin(this, 2));
        this.getEventSupport().firePropertyChange(PROPERTY_WHEN_NO_DATA_CELL, old, this.whenNoDataCell);
    }

    @Override
    public JRElement getElementByKey(String elementKey) {
        return JRBaseCrosstab.getElementByKey(this, elementKey);
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    public void setHeaderCell(JRDesignCellContents headerCell) {
        JRDesignCellContents old = this.headerCell;
        this.headerCell = headerCell;
        this.setCellOrigin(this.headerCell, new JRCrosstabOrigin(this, 1));
        this.getEventSupport().firePropertyChange(PROPERTY_HEADER_CELL, old, this.headerCell);
    }

    protected void measureClassChanged(JRDesignCrosstabMeasure measure, String valueClassName) {
        for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
            this.setTotalVarClass(measure, null, colGroup, valueClassName);
        }
        for (JRCrosstabRowGroup rowGroup : this.rowGroups) {
            this.setTotalVarClass(measure, rowGroup, null, valueClassName);
            for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
                this.setTotalVarClass(measure, rowGroup, colGroup, valueClassName);
            }
        }
    }

    protected void setTotalVarClass(JRCrosstabMeasure measure, JRCrosstabRowGroup rowGroup, JRCrosstabColumnGroup colGroup, String valueClassName) {
        JRDesignVariable variable = this.getVariable(JRDesignCrosstab.getTotalVariableName(measure, rowGroup, colGroup));
        variable.setValueClassName(valueClassName);
    }

    private void addVariable(JRVariable variable) {
        this.variablesList.put(variable.getName(), variable);
    }

    private void removeVariable(JRVariable variable) {
        this.removeVariable(variable.getName());
    }

    private void removeVariable(String varName) {
        this.variablesList.remove(varName);
    }

    private JRDesignVariable getVariable(String varName) {
        return (JRDesignVariable)this.variablesList.get(varName);
    }

    @Override
    public RunDirectionEnum getRunDirectionValue() {
        return this.runDirectionValue;
    }

    @Override
    public void setRunDirection(RunDirectionEnum runDirectionValue) {
        RunDirectionEnum old = this.runDirectionValue;
        this.runDirectionValue = runDirectionValue;
        this.getEventSupport().firePropertyChange("runDirection", old, this.runDirectionValue);
    }

    protected void setCellOrigin(JRCellContents cell, JRCrosstabOrigin origin) {
        if (cell instanceof JRDesignCellContents) {
            this.setCellOrigin((JRDesignCellContents)cell, origin);
        }
    }

    protected void setCellOrigin(JRDesignCellContents cell, JRCrosstabOrigin origin) {
        if (cell != null) {
            cell.setOrigin(origin);
        }
    }

    protected void setParent(JRDesignCrosstabGroup group) {
        if (group != null) {
            group.setParent(this);
        }
    }

    @Override
    public Object clone() {
        JRDesignCrosstabGroup groupClone;
        JRDesignCrosstabGroup group;
        JRDesignCrosstab clone = (JRDesignCrosstab)super.clone();
        if (this.parametersList != null) {
            clone.parametersList = new ArrayList<JRCrosstabParameter>(this.parametersList.size());
            clone.parametersMap = new HashMap<String, JRCrosstabParameter>(this.parametersList.size());
            for (int i2 = 0; i2 < this.parametersList.size(); ++i2) {
                JRCrosstabParameter parameter = (JRCrosstabParameter)JRCloneUtils.nullSafeClone((JRCloneable)this.parametersList.get(i2));
                clone.parametersList.add(parameter);
                clone.parametersMap.put(parameter.getName(), parameter);
            }
        }
        clone.parametersMapExpression = JRCloneUtils.nullSafeClone(this.parametersMapExpression);
        clone.dataset = JRCloneUtils.nullSafeClone(this.dataset);
        clone.lineBox = this.lineBox.clone(clone);
        HashMap<JRDesignVariable, JRDesignVariable> clonedVariables = new HashMap<JRDesignVariable, JRDesignVariable>();
        if (this.rowGroups != null) {
            clone.rowGroups = new ArrayList<JRCrosstabRowGroup>(this.rowGroups.size());
            clone.rowGroupsMap = new HashMap<String, Integer>(this.rowGroups.size());
            for (int i3 = 0; i3 < this.rowGroups.size(); ++i3) {
                group = (JRDesignCrosstabRowGroup)this.rowGroups.get(i3);
                groupClone = (JRDesignCrosstabRowGroup)group.clone(clone);
                clone.rowGroups.add((JRCrosstabRowGroup)((Object)groupClone));
                clone.rowGroupsMap.put(groupClone.getName(), i3);
                this.adjustCrosstabReference(clone, (JRDesignCellContents)groupClone.getTotalHeader());
                this.adjustCrosstabReference(clone, (JRDesignCellContents)groupClone.getHeader());
                if (((JRDesignCrosstabRowGroup)group).designVariable == null) continue;
                clonedVariables.put(((JRDesignCrosstabRowGroup)group).designVariable, ((JRDesignCrosstabRowGroup)groupClone).designVariable);
            }
        }
        if (this.columnGroups != null) {
            clone.columnGroups = new ArrayList<JRCrosstabColumnGroup>(this.columnGroups.size());
            clone.columnGroupsMap = new HashMap<String, Integer>(this.columnGroups.size());
            for (int i4 = 0; i4 < this.columnGroups.size(); ++i4) {
                group = (JRDesignCrosstabColumnGroup)this.columnGroups.get(i4);
                groupClone = (JRDesignCrosstabColumnGroup)group.clone(clone);
                clone.columnGroups.add((JRCrosstabColumnGroup)((Object)groupClone));
                clone.columnGroupsMap.put(groupClone.getName(), i4);
                this.adjustCrosstabReference(clone, (JRDesignCellContents)groupClone.getTotalHeader());
                this.adjustCrosstabReference(clone, (JRDesignCellContents)groupClone.getHeader());
                if (((JRDesignCrosstabColumnGroup)group).designVariable == null) continue;
                clonedVariables.put(((JRDesignCrosstabColumnGroup)group).designVariable, ((JRDesignCrosstabColumnGroup)groupClone).designVariable);
            }
        }
        if (this.measures != null) {
            clone.measures = new ArrayList<JRCrosstabMeasure>(this.measures.size());
            clone.measuresMap = new HashMap<String, Integer>(this.measures.size());
            for (int i5 = 0; i5 < this.measures.size(); ++i5) {
                JRDesignCrosstabMeasure measure = (JRDesignCrosstabMeasure)this.measures.get(i5);
                JRDesignCrosstabMeasure clonedMeasure = JRCloneUtils.nullSafeClone(measure);
                clone.measures.add(clonedMeasure);
                clone.measuresMap.put(clonedMeasure.getName(), i5);
                if (clonedMeasure.designVariable == null) continue;
                clonedVariables.put(measure.designVariable, clonedMeasure.designVariable);
            }
        }
        if (this.variablesList != null) {
            clone.variablesList = new SequencedHashMap(this.variablesList.size());
            for (JRVariable variable : this.variablesList.values()) {
                JRVariable variableClone = (JRVariable)clonedVariables.get(variable);
                variableClone = JRCloneUtils.nullSafeClone(variable);
                clone.variablesList.put(variableClone.getName(), variableClone);
            }
        }
        if (this.cellsList != null) {
            clone.cellsList = new ArrayList<JRCrosstabCell>(this.cellsList.size());
            clone.cellsMap = new HashMap<Pair, JRCrosstabCell>(this.cellsList.size());
            for (int i6 = 0; i6 < this.cellsList.size(); ++i6) {
                JRCrosstabCell cell = (JRCrosstabCell)JRCloneUtils.nullSafeClone((JRCloneable)this.cellsList.get(i6));
                this.adjustCrosstabReference(clone, (JRDesignCellContents)cell.getContents());
                clone.cellsList.add(cell);
                clone.cellsMap.put(new Pair<String, String>(cell.getRowTotalGroup(), cell.getColumnTotalGroup()), cell);
            }
        }
        clone.crossCells = null;
        clone.whenNoDataCell = JRCloneUtils.nullSafeClone(this.whenNoDataCell);
        this.adjustCrosstabReference(clone, clone.whenNoDataCell);
        clone.headerCell = JRCloneUtils.nullSafeClone(this.headerCell);
        this.adjustCrosstabReference(clone, clone.headerCell);
        return clone;
    }

    private void adjustCrosstabReference(JRDesignCrosstab clone, JRDesignCellContents contents) {
        if (contents == null) {
            return;
        }
        contents.setOrigin(new JRCrosstabOrigin(clone, contents.getOrigin().getType(), contents.getOrigin().getRowGroupName(), contents.getOrigin().getColumnGroupName()));
    }

    public List<JRCrosstabRowGroup> getRowGroupsList() {
        return this.rowGroups;
    }

    public Map<String, Integer> getRowGroupIndicesMap() {
        return this.rowGroupsMap;
    }

    public List<JRCrosstabColumnGroup> getColumnGroupsList() {
        return this.columnGroups;
    }

    public Map<String, Integer> getColumnGroupIndicesMap() {
        return this.columnGroupsMap;
    }

    public List<JRCrosstabMeasure> getMesuresList() {
        return this.measures;
    }

    public Map<String, Integer> getMeasureIndicesMap() {
        return this.measuresMap;
    }

    @Override
    public Boolean getIgnoreWidth() {
        return this.ignoreWidth;
    }

    @Override
    public void setIgnoreWidth(Boolean ignoreWidth) {
        Boolean old = this.ignoreWidth;
        this.ignoreWidth = ignoreWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_IGNORE_WIDTH, old, this.ignoreWidth);
    }

    @Override
    public void setIgnoreWidth(boolean ignoreWidth) {
        this.setIgnoreWidth((Boolean)ignoreWidth);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.runDirectionValue = RunDirectionEnum.getByValue(this.runDirection);
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
        }
    }

    private class MeasureClassChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 10200L;

        private MeasureClassChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JRDesignCrosstab.this.measureClassChanged((JRDesignCrosstabMeasure)evt.getSource(), (String)evt.getNewValue());
        }
    }
}

