/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table;

import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpressionCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnExpressionCollector
implements ColumnVisitor<Void> {
    private final JRExpressionCollector mainCollector;
    private final JRExpressionCollector datasetCollector;

    public ColumnExpressionCollector(JRExpressionCollector mainCollector, JRExpressionCollector datasetCollector) {
        this.mainCollector = mainCollector;
        this.datasetCollector = datasetCollector;
    }

    public void collectColumns(List<BaseColumn> columns) {
        for (BaseColumn column : columns) {
            column.visitColumn(this);
        }
    }

    @Override
    public Void visitColumn(Column column) {
        this.mainCollector.addExpression(column.getPrintWhenExpression());
        this.collectCell(column.getTableHeader());
        this.collectCell(column.getTableFooter());
        this.collectGroupCells(column.getGroupHeaders());
        this.collectGroupCells(column.getGroupFooters());
        this.collectCell(column.getColumnHeader());
        this.collectCell(column.getColumnFooter());
        this.collectCell(column.getDetailCell());
        return null;
    }

    @Override
    public Void visitColumnGroup(ColumnGroup columnGroup) {
        this.mainCollector.addExpression(columnGroup.getPrintWhenExpression());
        this.collectCell(columnGroup.getTableHeader());
        this.collectCell(columnGroup.getTableFooter());
        this.collectGroupCells(columnGroup.getGroupHeaders());
        this.collectGroupCells(columnGroup.getGroupFooters());
        this.collectCell(columnGroup.getColumnHeader());
        this.collectCell(columnGroup.getColumnFooter());
        this.collectColumns(columnGroup.getColumns());
        return null;
    }

    protected void collectGroupCells(List<GroupCell> groupCells) {
        if (groupCells != null) {
            for (GroupCell groupCell : groupCells) {
                this.collectCell(groupCell.getCell());
            }
        }
    }

    protected void collectCell(Cell cell) {
        if (cell == null) {
            return;
        }
        this.datasetCollector.collect(cell.getStyle());
        JRElement[] elements = cell.getElements();
        if (elements != null) {
            for (int i2 = 0; i2 < elements.length; ++i2) {
                elements[i2].collectExpressions(this.datasetCollector);
            }
        }
    }
}

