/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.ListContents;
import net.sf.jasperreports.components.list.StandardListComponent;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.type.PrintOrderEnum;

public class ListComponentCompiler
implements ComponentCompiler {
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        ListComponent listComponent = (ListComponent)component;
        JRDatasetRun datasetRun = listComponent.getDatasetRun();
        collector.collect(datasetRun);
        JRExpressionCollector datasetCollector = collector.getDatasetCollector(datasetRun.getDatasetName());
        JRElement[] elements = listComponent.getContents().getElements();
        if (elements != null) {
            for (int i2 = 0; i2 < elements.length; ++i2) {
                elements[i2].collectExpressions(datasetCollector);
            }
        }
    }

    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        ListComponent listComponent = (ListComponent)component;
        StandardListComponent compiledComponent = new StandardListComponent(listComponent, baseFactory);
        return compiledComponent;
    }

    public void verify(Component component, JRVerifier verifier) {
        ListComponent listComponent = (ListComponent)component;
        JRDatasetRun datasetRun = listComponent.getDatasetRun();
        if (datasetRun == null) {
            verifier.addBrokenRule("No list subdataset run set", (Object)listComponent);
        } else {
            verifier.verifyDatasetRun(datasetRun);
        }
        ListContents listContents = listComponent.getContents();
        if (listContents == null) {
            verifier.addBrokenRule("No list contents set", (Object)listComponent);
        } else {
            JRElement[] elements;
            int contentsWidth;
            boolean ignoreWidth;
            PrintOrderEnum listPrintOrder = listComponent.getPrintOrderValue() == null ? PrintOrderEnum.VERTICAL : listComponent.getPrintOrderValue();
            Boolean listIgnoreWidth = listComponent.getIgnoreWidth();
            boolean bl = ignoreWidth = listIgnoreWidth != null && listIgnoreWidth != false;
            if (listContents.getHeight() < 0) {
                verifier.addBrokenRule("List contents height must be positive.", (Object)listContents);
            }
            int elementWidth = verifier.getCurrentComponentElement().getWidth();
            Integer width = listContents.getWidth();
            if (width == null) {
                contentsWidth = elementWidth;
                if (listPrintOrder == PrintOrderEnum.HORIZONTAL) {
                    verifier.addBrokenRule("List contents width must be set for horizontal lists", (Object)listContents);
                }
            } else {
                contentsWidth = width;
                if (width <= 0) {
                    verifier.addBrokenRule("List contents width must be positive.", (Object)listContents);
                }
                if (!ignoreWidth && listPrintOrder == PrintOrderEnum.HORIZONTAL && width > elementWidth) {
                    verifier.addBrokenRule("List contents width is larger than the list element width", (Object)listComponent);
                }
            }
            if ((elements = listContents.getElements()) != null) {
                for (int i2 = 0; i2 < elements.length; ++i2) {
                    JRElement element = elements[i2];
                    verifier.verifyElement(element);
                    if (element.getX() < 0 || element.getY() < 0) {
                        verifier.addBrokenRule("Element must be placed at positive coordinates.", (Object)element);
                    }
                    if (element.getY() + element.getHeight() > listContents.getHeight()) {
                        verifier.addBrokenRule("Element reaches outside list contents height: y = " + element.getY() + ", height = " + element.getHeight() + ", list contents height = " + listContents.getHeight() + ".", (Object)element);
                    }
                    if (element.getX() + element.getWidth() <= contentsWidth) continue;
                    verifier.addBrokenRule("Element reaches outside list contents width: x = " + element.getX() + ", width = " + element.getWidth() + ", list contents width = " + contentsWidth + ".", (Object)element);
                }
            }
        }
    }
}

