/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import org.apache.harmony.security.internal.nls.Messages;

public class ECPoint {
    public static final ECPoint POINT_INFINITY = new ECPoint();
    private final BigInteger affineX;
    private final BigInteger affineY;

    private ECPoint() {
        this.affineX = null;
        this.affineY = null;
    }

    public ECPoint(BigInteger bigInteger, BigInteger bigInteger2) {
        this.affineX = bigInteger;
        if (this.affineX == null) {
            throw new NullPointerException(Messages.getString("security.83", "X"));
        }
        this.affineY = bigInteger2;
        if (this.affineY == null) {
            throw new NullPointerException(Messages.getString("security.83", "Y"));
        }
    }

    public BigInteger getAffineX() {
        return this.affineX;
    }

    public BigInteger getAffineY() {
        return this.affineY;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ECPoint) {
            if (this.affineX != null) {
                ECPoint eCPoint = (ECPoint)object;
                return this.affineX.equals(eCPoint.affineX) && this.affineY.equals(eCPoint.affineY);
            }
            return object == POINT_INFINITY;
        }
        return false;
    }

    public int hashCode() {
        if (this.affineX != null) {
            return this.affineX.hashCode() * 31 + this.affineY.hashCode();
        }
        return 11;
    }
}

