/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.apache.harmony.security.internal.nls.Messages;

public class ECParameterSpec
implements AlgorithmParameterSpec {
    private final EllipticCurve curve;
    private final ECPoint generator;
    private final BigInteger order;
    private final int cofactor;

    public ECParameterSpec(EllipticCurve ellipticCurve, ECPoint eCPoint, BigInteger bigInteger, int n2) {
        this.curve = ellipticCurve;
        this.generator = eCPoint;
        this.order = bigInteger;
        this.cofactor = n2;
        if (this.curve == null) {
            throw new NullPointerException(Messages.getString("security.83", "curve"));
        }
        if (this.generator == null) {
            throw new NullPointerException(Messages.getString("security.83", "generator"));
        }
        if (this.order == null) {
            throw new NullPointerException(Messages.getString("security.83", "order"));
        }
        if (this.order.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException(Messages.getString("security.86", "order"));
        }
        if (this.cofactor <= 0) {
            throw new IllegalArgumentException(Messages.getString("security.86", "cofactor"));
        }
    }

    public int getCofactor() {
        return this.cofactor;
    }

    public EllipticCurve getCurve() {
        return this.curve;
    }

    public ECPoint getGenerator() {
        return this.generator;
    }

    public BigInteger getOrder() {
        return this.order;
    }
}

