/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.harmony.security.Util;
import org.apache.harmony.security.fortress.Engine;
import org.apache.harmony.security.fortress.PolicyUtils;
import org.apache.harmony.security.fortress.SecurityAccess;
import org.apache.harmony.security.fortress.Services;
import org.apache.harmony.security.internal.nls.Messages;

public final class Security {
    private static Properties secprops = new Properties();
    private static SecurityManager SECURITY_MANAGER = new SecurityManager();

    private Security() {
    }

    private static void registerDefaultProviders() {
        secprops.put("security.provider.1", "com.ibm.jsse2.IBMJSSEProvider2");
        secprops.put("security.provider.2", "com.ibm.crypto.provider.IBMJCE");
        secprops.put("security.provider.3", "com.ibm.security.jgss.IBMJGSSProvider");
        secprops.put("security.provider.4", "com.ibm.security.cert.IBMCertPath");
        secprops.put("security.provider.5", "com.ibm.security.sasl.IBMSASL");
        secprops.put("security.provider.6", "com.ibm.xml.crypto.IBMXMLCryptoProvider");
        secprops.put("security.provider.7", "com.ibm.xml.enc.IBMXMLEncProvider");
        secprops.put("security.provider.8", "org.apache.harmony.security.provider.PolicyProvider");
        secprops.put("security.provider.9", "com.ibm.security.jgss.mech.spnego.IBMSPNEGO");
    }

    @Deprecated
    public static String getAlgorithmProperty(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = string2 + "." + string;
        Provider[] providerArray = Security.getProviders();
        for (int i2 = 0; i2 < providerArray.length; ++i2) {
            Enumeration<?> enumeration = providerArray[i2].propertyNames();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                if (!Util.equalsIgnoreCase(string3, string4)) continue;
                return providerArray[i2].getProperty(string4);
            }
        }
        return null;
    }

    public static synchronized int insertProviderAt(Provider provider, int n2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("insertProvider." + provider.getName());
        }
        if (Security.getProvider(provider.getName()) != null) {
            return -1;
        }
        int n3 = Services.insertProviderAt(provider, n2);
        Security.renumProviders();
        return n3;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, 0);
    }

    public static synchronized void removeProvider(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        Provider provider = Security.getProvider(string);
        if (provider == null) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("removeProvider." + string);
        }
        Services.removeProvider(provider.getProviderNumber());
        Security.renumProviders();
        provider.setProviderNumber(-1);
    }

    public static Provider[] getProviders() {
        return Services.getProviders();
    }

    public static Provider getProvider(String string) {
        return Services.getProvider(string);
    }

    public static Provider[] getProviders(String string) {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.2A"));
        }
        if (string.length() == 0) {
            throw new InvalidParameterException(Messages.getString("security.2B"));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = string.indexOf(":");
        if (n2 == string.length() - 1 || n2 == 0) {
            throw new InvalidParameterException(Messages.getString("security.2B"));
        }
        if (n2 < 1) {
            hashMap.put(string, "");
        } else {
            hashMap.put(string.substring(0, n2), string.substring(n2 + 1));
        }
        return Security.getProviders(hashMap);
    }

    public static Provider[] getProviders(Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException(Messages.getString("security.2A"));
        }
        if (map.isEmpty()) {
            return null;
        }
        List<Provider> list = Services.getProvidersList();
        Set<Map.Entry<String, String>> set = map.entrySet();
        block2: for (Map.Entry<String, String> entry : set) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            String string3 = null;
            int n2 = string.indexOf(" ");
            int n3 = string.indexOf(".");
            if (n3 == -1) {
                throw new InvalidParameterException(Messages.getString("security.2B"));
            }
            if (n2 == -1) {
                if (string2.length() != 0) {
                    throw new InvalidParameterException(Messages.getString("security.2B"));
                }
            } else {
                if (string2.length() == 0) {
                    string2 = null;
                }
                if ((string3 = string.substring(n2 + 1)).trim().length() == 0) {
                    throw new InvalidParameterException(Messages.getString("security.2B"));
                }
                string = string.substring(0, n2);
            }
            String string4 = string.substring(0, n3);
            String string5 = string.substring(n3 + 1);
            if (string4.length() == 0 || string5.length() == 0) {
                throw new InvalidParameterException(Messages.getString("security.2B"));
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Provider provider;
                try {
                    provider = list.get(i2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue block2;
                }
                if (provider.implementsAlg(string4, string5, string3, string2)) continue;
                list.remove(provider);
                --i2;
            }
        }
        if (list.size() > 0) {
            return list.toArray(new Provider[list.size()]);
        }
        return null;
    }

    public static String getProperty(String string) {
        String string2;
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.2C"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("getProperty." + string);
        }
        if ((string2 = secprops.getProperty(string)) != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static void setProperty(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("setProperty." + string);
        }
        secprops.put(string, string2);
        if (string.equals("package.access") || string.equals("package.definition")) {
            Security.setInternalField("packageAccessValid", SECURITY_MANAGER, false);
        }
    }

    public static Set<String> getAlgorithms(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Provider[] providerArray = Security.getProviders();
        for (int i2 = 0; i2 < providerArray.length; ++i2) {
            for (Provider.Service service : providerArray[i2].getServices()) {
                if (!Util.equalsIgnoreCase(service.getType(), string)) continue;
                hashSet.add(service.getAlgorithm());
            }
        }
        return hashSet;
    }

    private static void renumProviders() {
        Provider[] providerArray = Services.getCreatedProviders();
        for (int i2 = 0; i2 < providerArray.length; ++i2) {
            providerArray[i2].setProviderNumber(i2 + 1);
        }
    }

    private static void setInternalField(final String string, final Object object, final boolean bl) {
        AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                Field field = null;
                try {
                    field = object.getClass().getDeclaredField(string);
                    field.setAccessible(true);
                    field.setBoolean(object, bl);
                }
                catch (Exception exception) {
                    return null;
                }
                return field;
            }
        });
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                BufferedInputStream bufferedInputStream;
                Object object;
                boolean bl = false;
                File file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "java.security");
                if (file.exists()) {
                    try {
                        object = new FileInputStream(file);
                        bufferedInputStream = new BufferedInputStream((InputStream)object);
                        secprops.load(bufferedInputStream);
                        bl = true;
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (Util.equalsIgnoreCase("true", secprops.getProperty("security.allowCustomPropertiesFile", "true")) && (object = System.getProperty("java.security.properties")) != null) {
                    if (((String)object).startsWith("=")) {
                        secprops = new Properties();
                        bl = false;
                        object = ((String)object).substring(1);
                    }
                    try {
                        object = PolicyUtils.expand((String)object, System.getProperties());
                    }
                    catch (PolicyUtils.ExpansionFailedException expansionFailedException) {
                        // empty catch block
                    }
                    file = new File((String)object);
                    try {
                        if (file.exists()) {
                            FileInputStream fileInputStream = new FileInputStream(file);
                            bufferedInputStream = new BufferedInputStream(fileInputStream);
                        } else {
                            URL uRL = new URL((String)object);
                            bufferedInputStream = new BufferedInputStream(uRL.openStream());
                        }
                        secprops.load(bufferedInputStream);
                        bl = true;
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    Security.registerDefaultProviders();
                }
                Engine.door = new SecurityDoor();
                return null;
            }
        });
    }

    private static class SecurityDoor
    implements SecurityAccess {
        private SecurityDoor() {
        }

        @Override
        public void renumProviders() {
            Security.renumProviders();
        }

        @Override
        public Iterator<String> getAliases(Provider.Service service) {
            return service.getAliases();
        }

        @Override
        public Provider.Service getService(Provider provider, String string) {
            return provider.getService(string);
        }
    }
}

