/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import org.apache.harmony.security.internal.nls.Messages;

public abstract class KeyStoreSpi {
    public abstract Key engineGetKey(String var1, char[] var2) throws NoSuchAlgorithmException, UnrecoverableKeyException;

    public abstract Certificate[] engineGetCertificateChain(String var1);

    public abstract Certificate engineGetCertificate(String var1);

    public abstract Date engineGetCreationDate(String var1);

    public abstract void engineSetKeyEntry(String var1, Key var2, char[] var3, Certificate[] var4) throws KeyStoreException;

    public abstract void engineSetKeyEntry(String var1, byte[] var2, Certificate[] var3) throws KeyStoreException;

    public abstract void engineSetCertificateEntry(String var1, Certificate var2) throws KeyStoreException;

    public abstract void engineDeleteEntry(String var1) throws KeyStoreException;

    public abstract Enumeration<String> engineAliases();

    public abstract boolean engineContainsAlias(String var1);

    public abstract int engineSize();

    public abstract boolean engineIsKeyEntry(String var1);

    public abstract boolean engineIsCertificateEntry(String var1);

    public abstract String engineGetCertificateAlias(Certificate var1);

    public abstract void engineStore(OutputStream var1, char[] var2) throws IOException, NoSuchAlgorithmException, CertificateException;

    public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException(Messages.getString("security.33"));
    }

    public abstract void engineLoad(InputStream var1, char[] var2) throws IOException, NoSuchAlgorithmException, CertificateException;

    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (loadStoreParameter == null) {
            this.engineLoad(null, null);
            return;
        }
        KeyStore.ProtectionParameter protectionParameter = loadStoreParameter.getProtectionParameter();
        if (protectionParameter instanceof KeyStore.PasswordProtection) {
            try {
                char[] cArray = ((KeyStore.PasswordProtection)protectionParameter).getPassword();
                this.engineLoad(null, cArray);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                throw new IllegalArgumentException(illegalStateException);
            }
        }
        if (protectionParameter instanceof KeyStore.CallbackHandlerProtection) {
            try {
                char[] cArray = KeyStoreSpi.getPasswordFromCallBack(protectionParameter);
                this.engineLoad(null, cArray);
                return;
            }
            catch (UnrecoverableEntryException unrecoverableEntryException) {
                throw new IllegalArgumentException(unrecoverableEntryException);
            }
        }
        throw new UnsupportedOperationException(Messages.getString("security.35"));
    }

    public KeyStore.Entry engineGetEntry(String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        if (this.engineIsCertificateEntry(string)) {
            return new KeyStore.TrustedCertificateEntry(this.engineGetCertificate(string));
        }
        char[] cArray = null;
        if (protectionParameter != null) {
            if (protectionParameter instanceof KeyStore.PasswordProtection) {
                try {
                    cArray = ((KeyStore.PasswordProtection)protectionParameter).getPassword();
                }
                catch (IllegalStateException illegalStateException) {
                    throw new KeyStoreException(Messages.getString("security.36"), illegalStateException);
                }
            } else if (protectionParameter instanceof KeyStore.CallbackHandlerProtection) {
                cArray = KeyStoreSpi.getPasswordFromCallBack(protectionParameter);
            } else {
                throw new UnrecoverableEntryException(Messages.getString("security.37", protectionParameter.toString()));
            }
        }
        if (this.engineIsKeyEntry(string)) {
            Key key = this.engineGetKey(string, cArray);
            if (key instanceof PrivateKey) {
                return new KeyStore.PrivateKeyEntry((PrivateKey)key, this.engineGetCertificateChain(string));
            }
            if (key instanceof SecretKey) {
                return new KeyStore.SecretKeyEntry((SecretKey)key);
            }
        }
        throw new NoSuchAlgorithmException(Messages.getString("security.38"));
    }

    public void engineSetEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        if (entry == null) {
            throw new KeyStoreException(Messages.getString("security.39"));
        }
        if (this.engineContainsAlias(string)) {
            this.engineDeleteEntry(string);
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trustedCertificateEntry = (KeyStore.TrustedCertificateEntry)entry;
            this.engineSetCertificateEntry(string, trustedCertificateEntry.getTrustedCertificate());
            return;
        }
        char[] cArray = null;
        if (protectionParameter instanceof KeyStore.PasswordProtection) {
            try {
                cArray = ((KeyStore.PasswordProtection)protectionParameter).getPassword();
            }
            catch (IllegalStateException illegalStateException) {
                throw new KeyStoreException(Messages.getString("security.36"), illegalStateException);
            }
        } else if (protectionParameter instanceof KeyStore.CallbackHandlerProtection) {
            try {
                cArray = KeyStoreSpi.getPasswordFromCallBack(protectionParameter);
            }
            catch (Exception exception) {
                throw new KeyStoreException(exception);
            }
        } else {
            throw new KeyStoreException(Messages.getString("security.3A"));
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
            this.engineSetKeyEntry(string, privateKeyEntry.getPrivateKey(), cArray, privateKeyEntry.getCertificateChain());
            return;
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
            this.engineSetKeyEntry(string, secretKeyEntry.getSecretKey(), cArray, null);
            return;
        }
        throw new KeyStoreException(Messages.getString("security.3B", entry.toString()));
    }

    public boolean engineEntryInstanceOf(String string, Class<? extends KeyStore.Entry> clazz) {
        if (!this.engineContainsAlias(string)) {
            return false;
        }
        try {
            if (this.engineIsCertificateEntry(string)) {
                return clazz.isAssignableFrom(Class.forName("java.security.KeyStore$TrustedCertificateEntry"));
            }
            if (this.engineIsKeyEntry(string)) {
                if (clazz.isAssignableFrom(Class.forName("java.security.KeyStore$PrivateKeyEntry"))) {
                    return this.engineGetCertificate(string) != null;
                }
                if (clazz.isAssignableFrom(Class.forName("java.security.KeyStore$SecretKeyEntry"))) {
                    return this.engineGetCertificate(string) == null;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static char[] getPasswordFromCallBack(KeyStore.ProtectionParameter protectionParameter) throws UnrecoverableEntryException {
        if (protectionParameter == null) {
            return null;
        }
        if (!(protectionParameter instanceof KeyStore.CallbackHandlerProtection)) {
            throw new UnrecoverableEntryException(Messages.getString("security.3C"));
        }
        String string = Security.getProperty("auth.login.defaultCallbackHandler");
        if (string == null) {
            throw new UnrecoverableEntryException(Messages.getString("security.3D"));
        }
        try {
            Class<?> clazz = Class.forName(string);
            CallbackHandler callbackHandler = (CallbackHandler)clazz.newInstance();
            Callback[] callbackArray = new PasswordCallback[]{new PasswordCallback("password: ", true)};
            callbackHandler.handle(callbackArray);
            return ((PasswordCallback)callbackArray[0]).getPassword();
        }
        catch (Exception exception) {
            throw new UnrecoverableEntryException(exception.toString());
        }
    }
}

