/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Certificate;
import java.security.IdentityScope;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Vector;
import org.apache.harmony.security.internal.nls.Messages;

@Deprecated
public abstract class Identity
implements Principal,
Serializable {
    private static final long serialVersionUID = 3609922007826600659L;
    private String name;
    private PublicKey publicKey;
    private String info = "no additional info";
    private IdentityScope scope;
    private Vector<Certificate> certificates;

    protected Identity() {
    }

    public Identity(String string) {
        this.name = string;
    }

    public Identity(String string, IdentityScope identityScope) throws KeyManagementException {
        this(string);
        if (identityScope != null) {
            identityScope.addIdentity(this);
            this.scope = identityScope;
        }
    }

    public void addCertificate(Certificate certificate) throws KeyManagementException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("addIdentityCertificate");
        }
        PublicKey publicKey = certificate.getPublicKey();
        if (this.publicKey != null) {
            if (!Identity.checkKeysEqual(this.publicKey, publicKey)) {
                throw new KeyManagementException(Messages.getString("security.13"));
            }
        } else {
            this.publicKey = publicKey;
        }
        if (this.certificates == null) {
            this.certificates = new Vector();
        }
        this.certificates.add(certificate);
    }

    private static boolean checkKeysEqual(PublicKey publicKey, PublicKey publicKey2) {
        String string;
        String string2 = publicKey.getFormat();
        if (publicKey2 == null || (string = publicKey2.getFormat()) != null ^ string2 != null || string2 != null && !string2.equals(string)) {
            return false;
        }
        return Arrays.equals(publicKey.getEncoded(), publicKey2.getEncoded());
    }

    public void removeCertificate(Certificate certificate) throws KeyManagementException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("removeIdentityCertificate");
        }
        if (this.certificates != null) {
            this.certificates.removeElement(certificate);
        }
    }

    public Certificate[] certificates() {
        if (this.certificates == null) {
            return new Certificate[0];
        }
        Object[] objectArray = new Certificate[this.certificates.size()];
        this.certificates.copyInto(objectArray);
        return objectArray;
    }

    protected boolean identityEquals(Identity identity) {
        if (!this.name.equals(identity.name)) {
            return false;
        }
        if (this.publicKey == null) {
            return identity.publicKey == null;
        }
        return Identity.checkKeysEqual(this.publicKey, identity.publicKey);
    }

    public String toString(boolean bl) {
        String string = this.toString();
        if (bl) {
            string = string + " " + this.info;
        }
        return string;
    }

    public final IdentityScope getScope() {
        return this.scope;
    }

    public void setPublicKey(PublicKey publicKey) throws KeyManagementException {
        Identity identity;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("setIdentityPublicKey");
        }
        if (this.scope != null && publicKey != null && (identity = this.scope.getIdentity(publicKey)) != null && identity != this) {
            throw new KeyManagementException(Messages.getString("security.14"));
        }
        this.publicKey = publicKey;
        this.certificates = null;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setInfo(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("setIdentityInfo");
        }
        this.info = string;
    }

    public String getInfo() {
        return this.info;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Identity)) {
            return false;
        }
        Identity identity = (Identity)object;
        if ((this.name == identity.name || this.name != null && this.name.equals(identity.name)) && (this.scope == identity.scope || this.scope != null && this.scope.equals(identity.scope))) {
            return true;
        }
        return this.identityEquals(identity);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        if (this.name != null) {
            n2 += this.name.hashCode();
        }
        if (this.scope != null) {
            n2 += this.scope.hashCode();
        }
        return n2;
    }

    @Override
    public String toString() {
        String string;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("printIdentity");
        }
        String string2 = string = this.name == null ? "" : this.name;
        if (this.scope != null) {
            string = string + " [" + this.scope.getName() + "]";
        }
        return string;
    }
}

