/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Timestamp;
import java.security.cert.CertPath;
import org.apache.harmony.security.internal.nls.Messages;

public final class CodeSigner
implements Serializable {
    private static final long serialVersionUID = 6819288105193937581L;
    private CertPath signerCertPath;
    private Timestamp timestamp;
    private transient int hash;

    public CodeSigner(CertPath certPath, Timestamp timestamp) {
        if (certPath == null) {
            throw new NullPointerException(Messages.getString("security.10"));
        }
        this.signerCertPath = certPath;
        this.timestamp = timestamp;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CodeSigner) {
            CodeSigner codeSigner = (CodeSigner)object;
            if (!this.signerCertPath.equals(codeSigner.signerCertPath)) {
                return false;
            }
            return this.timestamp == null ? codeSigner.timestamp == null : this.timestamp.equals(codeSigner.timestamp);
        }
        return false;
    }

    public CertPath getSignerCertPath() {
        return this.signerCertPath;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.signerCertPath.hashCode() ^ (this.timestamp == null ? 0 : this.timestamp.hashCode());
        }
        return this.hash;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("CodeSigner [").append(this.signerCertPath.getCertificates().get(0));
        if (this.timestamp != null) {
            stringBuffer.append("; ").append(this.timestamp);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

