/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Image;
import com.lowagie.text.LargeElement;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTableEvent;
import com.lowagie.text.pdf.events.PdfPTableEventForwarder;
import java.util.ArrayList;

public class PdfPTable
implements LargeElement {
    public static final int BASECANVAS = 0;
    public static final int BACKGROUNDCANVAS = 1;
    public static final int LINECANVAS = 2;
    public static final int TEXTCANVAS = 3;
    protected ArrayList rows = new ArrayList();
    protected float totalHeight = 0.0f;
    protected PdfPCell[] currentRow;
    protected int currentRowIdx = 0;
    protected PdfPCell defaultCell = new PdfPCell((Phrase)null);
    protected float totalWidth = 0.0f;
    protected float[] relativeWidths;
    protected float[] absoluteWidths;
    protected PdfPTableEvent tableEvent;
    protected int headerRows;
    protected float widthPercentage = 80.0f;
    private int horizontalAlignment = 1;
    private boolean skipFirstHeader = false;
    private boolean skipLastFooter = false;
    protected boolean isColspan = false;
    protected int runDirection = 0;
    private boolean lockedWidth = false;
    private boolean splitRows = true;
    protected float spacingBefore;
    protected float spacingAfter;
    private boolean extendLastRow;
    private boolean headersInEvent;
    private boolean splitLate = true;
    private boolean keepTogether;
    protected boolean complete = true;
    private int footerRows;
    protected boolean rowCompleted = true;

    protected PdfPTable() {
    }

    public PdfPTable(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException("The widths array in PdfPTable constructor can not be null.");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("The widths array in PdfPTable constructor can not have zero length.");
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
        this.keepTogether = false;
    }

    public PdfPTable(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("The number of columns in PdfPTable constructor must be greater than zero.");
        }
        this.relativeWidths = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.relativeWidths[i2] = 1.0f;
        }
        this.absoluteWidths = new float[this.relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
        this.keepTogether = false;
    }

    public PdfPTable(PdfPTable pdfPTable) {
        int n2;
        this.copyFormat(pdfPTable);
        for (n2 = 0; n2 < this.currentRow.length && pdfPTable.currentRow[n2] != null; ++n2) {
            this.currentRow[n2] = new PdfPCell(pdfPTable.currentRow[n2]);
        }
        for (n2 = 0; n2 < pdfPTable.rows.size(); ++n2) {
            PdfPRow pdfPRow = (PdfPRow)pdfPTable.rows.get(n2);
            if (pdfPRow != null) {
                pdfPRow = new PdfPRow(pdfPRow);
            }
            this.rows.add(pdfPRow);
        }
    }

    public static PdfPTable shallowCopy(PdfPTable pdfPTable) {
        PdfPTable pdfPTable2 = new PdfPTable();
        pdfPTable2.copyFormat(pdfPTable);
        return pdfPTable2;
    }

    protected void copyFormat(PdfPTable pdfPTable) {
        this.relativeWidths = new float[pdfPTable.getNumberOfColumns()];
        this.absoluteWidths = new float[pdfPTable.getNumberOfColumns()];
        System.arraycopy(pdfPTable.relativeWidths, 0, this.relativeWidths, 0, this.getNumberOfColumns());
        System.arraycopy(pdfPTable.absoluteWidths, 0, this.absoluteWidths, 0, this.getNumberOfColumns());
        this.totalWidth = pdfPTable.totalWidth;
        this.totalHeight = pdfPTable.totalHeight;
        this.currentRowIdx = 0;
        this.tableEvent = pdfPTable.tableEvent;
        this.runDirection = pdfPTable.runDirection;
        this.defaultCell = new PdfPCell(pdfPTable.defaultCell);
        this.currentRow = new PdfPCell[pdfPTable.currentRow.length];
        this.isColspan = pdfPTable.isColspan;
        this.splitRows = pdfPTable.splitRows;
        this.spacingAfter = pdfPTable.spacingAfter;
        this.spacingBefore = pdfPTable.spacingBefore;
        this.headerRows = pdfPTable.headerRows;
        this.footerRows = pdfPTable.footerRows;
        this.lockedWidth = pdfPTable.lockedWidth;
        this.extendLastRow = pdfPTable.extendLastRow;
        this.headersInEvent = pdfPTable.headersInEvent;
        this.widthPercentage = pdfPTable.widthPercentage;
        this.splitLate = pdfPTable.splitLate;
        this.skipFirstHeader = pdfPTable.skipFirstHeader;
        this.skipLastFooter = pdfPTable.skipLastFooter;
        this.horizontalAlignment = pdfPTable.horizontalAlignment;
        this.keepTogether = pdfPTable.keepTogether;
        this.complete = pdfPTable.complete;
    }

    public void setWidths(float[] fArray) throws DocumentException {
        if (fArray.length != this.getNumberOfColumns()) {
            throw new DocumentException("Wrong number of columns.");
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights(true);
    }

    public void setWidths(int[] nArray) throws DocumentException {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        this.setWidths(fArray);
    }

    protected void calculateWidths() {
        int n2;
        if (this.totalWidth <= 0.0f) {
            return;
        }
        float f2 = 0.0f;
        int n3 = this.getNumberOfColumns();
        for (n2 = 0; n2 < n3; ++n2) {
            f2 += this.relativeWidths[n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.absoluteWidths[n2] = this.totalWidth * this.relativeWidths[n2] / f2;
        }
    }

    public void setTotalWidth(float f2) {
        if (this.totalWidth == f2) {
            return;
        }
        this.totalWidth = f2;
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights(true);
    }

    public void setTotalWidth(float[] fArray) throws DocumentException {
        if (fArray.length != this.getNumberOfColumns()) {
            throw new DocumentException("Wrong number of columns.");
        }
        this.totalWidth = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.totalWidth += fArray[i2];
        }
        this.setWidths(fArray);
    }

    public void setWidthPercentage(float[] fArray, Rectangle rectangle) throws DocumentException {
        if (fArray.length != this.getNumberOfColumns()) {
            throw new IllegalArgumentException("Wrong number of columns.");
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            f2 += fArray[i2];
        }
        this.widthPercentage = f2 / (rectangle.getRight() - rectangle.getLeft()) * 100.0f;
        this.setWidths(fArray);
    }

    public float getTotalWidth() {
        return this.totalWidth;
    }

    public float calculateHeights(boolean bl) {
        if (this.totalWidth <= 0.0f) {
            return 0.0f;
        }
        this.totalHeight = 0.0f;
        for (int i2 = 0; i2 < this.rows.size(); ++i2) {
            this.totalHeight += this.getRowHeight(i2, bl);
        }
        return this.totalHeight;
    }

    public void calculateHeightsFast() {
        this.calculateHeights(false);
    }

    public PdfPCell getDefaultCell() {
        return this.defaultCell;
    }

    public void addCell(PdfPCell pdfPCell) {
        int n2;
        this.rowCompleted = false;
        PdfPCell pdfPCell2 = new PdfPCell(pdfPCell);
        int n3 = pdfPCell2.getColspan();
        n3 = Math.max(n3, 1);
        n3 = Math.min(n3, this.currentRow.length - this.currentRowIdx);
        pdfPCell2.setColspan(n3);
        if (n3 != 1) {
            this.isColspan = true;
        }
        if ((n2 = pdfPCell2.getRunDirection()) == 0) {
            pdfPCell2.setRunDirection(this.runDirection);
        }
        this.skipColsWithRowspanAbove();
        boolean bl = false;
        if (this.currentRowIdx < this.currentRow.length) {
            this.currentRow[this.currentRowIdx] = pdfPCell2;
            this.currentRowIdx += n3;
            bl = true;
        }
        this.skipColsWithRowspanAbove();
        if (this.currentRowIdx >= this.currentRow.length) {
            Object object;
            int n4 = this.getNumberOfColumns();
            if (this.runDirection == 3) {
                object = new PdfPCell[n4];
                int n5 = this.currentRow.length;
                for (int i2 = 0; i2 < this.currentRow.length; ++i2) {
                    PdfPCell pdfPCell3 = this.currentRow[i2];
                    int n6 = pdfPCell3.getColspan();
                    object[n5 -= n6] = pdfPCell3;
                    i2 += n6 - 1;
                }
                this.currentRow = object;
            }
            object = new PdfPRow(this.currentRow);
            if (this.totalWidth > 0.0f) {
                ((PdfPRow)object).setWidths(this.absoluteWidths);
                this.totalHeight += ((PdfPRow)object).getMaxHeights();
            }
            this.rows.add(object);
            this.currentRow = new PdfPCell[n4];
            this.currentRowIdx = 0;
            this.rowCompleted = true;
        }
        if (!bl) {
            this.currentRow[this.currentRowIdx] = pdfPCell2;
            this.currentRowIdx += n3;
        }
    }

    private void skipColsWithRowspanAbove() {
        int n2 = 1;
        if (this.runDirection == 3) {
            n2 = -1;
        }
        while (this.rowSpanAbove(this.rows.size(), this.currentRowIdx)) {
            this.currentRowIdx += n2;
        }
    }

    boolean rowSpanAbove(int n2, int n3) {
        if (n3 >= this.getNumberOfColumns() || n3 < 0 || n2 == 0) {
            return false;
        }
        int n4 = n2 - 1;
        PdfPRow pdfPRow = (PdfPRow)this.rows.get(n4);
        if (pdfPRow == null) {
            return false;
        }
        PdfPCell pdfPCell = pdfPRow.getCells()[n3];
        while (pdfPCell == null && n4 > 0) {
            if ((pdfPRow = (PdfPRow)this.rows.get(--n4)) == null) {
                return false;
            }
            pdfPCell = pdfPRow.getCells()[n3];
        }
        int n5 = n2 - n4;
        if (pdfPCell == null) {
            int n6 = n3 - 1;
            pdfPCell = pdfPRow.getCells()[n6];
            while (pdfPCell == null && n4 > 0) {
                pdfPCell = pdfPRow.getCells()[--n6];
            }
            return pdfPCell != null && pdfPCell.getRowspan() > n5;
        }
        if (pdfPCell.getRowspan() == 1 && n5 > 1) {
            int n7 = n3 - 1;
            pdfPRow = (PdfPRow)this.rows.get(n4 + 1);
            --n5;
            pdfPCell = pdfPRow.getCells()[n7];
            while (pdfPCell == null && n7 > 0) {
                pdfPCell = pdfPRow.getCells()[--n7];
            }
        }
        return pdfPCell != null && pdfPCell.getRowspan() > n5;
    }

    public void addCell(String string) {
        this.addCell(new Phrase(string));
    }

    public void addCell(PdfPTable pdfPTable) {
        this.defaultCell.setTable(pdfPTable);
        this.addCell(this.defaultCell);
        this.defaultCell.setTable(null);
    }

    public void addCell(Image image) {
        this.defaultCell.setImage(image);
        this.addCell(this.defaultCell);
        this.defaultCell.setImage(null);
    }

    public void addCell(Phrase phrase) {
        this.defaultCell.setPhrase(phrase);
        this.addCell(this.defaultCell);
        this.defaultCell.setPhrase(null);
    }

    public float writeSelectedRows(int n2, int n3, float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        return this.writeSelectedRows(0, -1, n2, n3, f2, f3, pdfContentByteArray);
    }

    public float writeSelectedRows(int n2, int n3, int n4, int n5, float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        if (this.totalWidth <= 0.0f) {
            throw new RuntimeException("The table width must be greater than zero.");
        }
        int n6 = this.rows.size();
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 >= (n5 = n5 < 0 ? n6 : Math.min(n5, n6))) {
            return f3;
        }
        int n7 = this.getNumberOfColumns();
        n2 = n2 < 0 ? 0 : Math.min(n2, n7);
        n3 = n3 < 0 ? n7 : Math.min(n3, n7);
        float f4 = f3;
        for (int i2 = n4; i2 < n5; ++i2) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(i2);
            if (pdfPRow == null) continue;
            pdfPRow.writeCells(n2, n3, f2, f3, pdfContentByteArray);
            f3 -= pdfPRow.getMaxHeights();
        }
        if (this.tableEvent != null && n2 == 0 && n3 == n7) {
            float[] fArray = new float[n5 - n4 + 1];
            fArray[0] = f4;
            for (int i3 = n4; i3 < n5; ++i3) {
                PdfPRow pdfPRow = (PdfPRow)this.rows.get(i3);
                float f5 = 0.0f;
                if (pdfPRow != null) {
                    f5 = pdfPRow.getMaxHeights();
                }
                fArray[i3 - n4 + 1] = fArray[i3 - n4] - f5;
            }
            this.tableEvent.tableLayout(this, this.getEventWidths(f2, n4, n5, this.headersInEvent), fArray, this.headersInEvent ? this.headerRows : 0, n4, pdfContentByteArray);
        }
        return f3;
    }

    public float writeSelectedRows(int n2, int n3, float f2, float f3, PdfContentByte pdfContentByte) {
        return this.writeSelectedRows(0, -1, n2, n3, f2, f3, pdfContentByte);
    }

    public float writeSelectedRows(int n2, int n3, int n4, int n5, float f2, float f3, PdfContentByte pdfContentByte) {
        float f4;
        boolean bl;
        int n6 = this.getNumberOfColumns();
        n2 = n2 < 0 ? 0 : Math.min(n2, n6);
        n3 = n3 < 0 ? n6 : Math.min(n3, n6);
        boolean bl2 = bl = n2 != 0 || n3 != n6;
        if (bl) {
            float f5 = 0.0f;
            for (int i2 = n2; i2 < n3; ++i2) {
                f5 += this.absoluteWidths[i2];
            }
            pdfContentByte.saveState();
            f4 = n2 == 0 ? 10000.0f : 0.0f;
            float f6 = n3 == n6 ? 10000.0f : 0.0f;
            pdfContentByte.rectangle(f2 - f4, -10000.0f, f5 + f4 + f6, 20000.0f);
            pdfContentByte.clip();
            pdfContentByte.newPath();
        }
        PdfContentByte[] pdfContentByteArray = PdfPTable.beginWritingRows(pdfContentByte);
        f4 = this.writeSelectedRows(n2, n3, n4, n5, f2, f3, pdfContentByteArray);
        PdfPTable.endWritingRows(pdfContentByteArray);
        if (bl) {
            pdfContentByte.restoreState();
        }
        return f4;
    }

    public static PdfContentByte[] beginWritingRows(PdfContentByte pdfContentByte) {
        return new PdfContentByte[]{pdfContentByte, pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate()};
    }

    public static void endWritingRows(PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[0];
        pdfContentByte.saveState();
        pdfContentByte.add(pdfContentByteArray[1]);
        pdfContentByte.restoreState();
        pdfContentByte.saveState();
        pdfContentByte.setLineCap(2);
        pdfContentByte.resetRGBColorStroke();
        pdfContentByte.add(pdfContentByteArray[2]);
        pdfContentByte.restoreState();
        pdfContentByte.add(pdfContentByteArray[3]);
    }

    public int size() {
        return this.rows.size();
    }

    public float getTotalHeight() {
        return this.totalHeight;
    }

    public float getRowHeight(int n2) {
        return this.getRowHeight(n2, false);
    }

    public float getRowHeight(int n2, boolean bl) {
        if (this.totalWidth <= 0.0f || n2 < 0 || n2 >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow pdfPRow = (PdfPRow)this.rows.get(n2);
        if (pdfPRow == null) {
            return 0.0f;
        }
        if (bl) {
            pdfPRow.setWidths(this.absoluteWidths);
        }
        float f2 = pdfPRow.getMaxHeights();
        for (int i2 = 0; i2 < this.relativeWidths.length; ++i2) {
            if (!this.rowSpanAbove(n2, i2)) continue;
            int n3 = 1;
            while (this.rowSpanAbove(n2 - n3, i2)) {
                ++n3;
            }
            PdfPRow pdfPRow2 = (PdfPRow)this.rows.get(n2 - n3);
            PdfPCell pdfPCell = pdfPRow2.getCells()[i2];
            float f3 = 0.0f;
            if (pdfPCell.getRowspan() == n3 + 1) {
                f3 = pdfPCell.getMaxHeight();
                while (n3 > 0) {
                    f3 -= this.getRowHeight(n2 - n3);
                    --n3;
                }
            }
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        pdfPRow.setMaxHeights(f2);
        return f2;
    }

    public float getRowspanHeight(int n2, int n3) {
        if (this.totalWidth <= 0.0f || n2 < 0 || n2 >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow pdfPRow = (PdfPRow)this.rows.get(n2);
        if (pdfPRow == null || n3 >= pdfPRow.getCells().length) {
            return 0.0f;
        }
        PdfPCell pdfPCell = pdfPRow.getCells()[n3];
        if (pdfPCell == null) {
            return 0.0f;
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < pdfPCell.getRowspan(); ++i2) {
            f2 += this.getRowHeight(n2 + i2);
        }
        return f2;
    }

    public float getHeaderHeight() {
        float f2 = 0.0f;
        int n2 = Math.min(this.rows.size(), this.headerRows);
        for (int i2 = 0; i2 < n2; ++i2) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(i2);
            if (pdfPRow == null) continue;
            f2 += pdfPRow.getMaxHeights();
        }
        return f2;
    }

    public float getFooterHeight() {
        float f2 = 0.0f;
        int n2 = Math.max(0, this.headerRows - this.footerRows);
        int n3 = Math.min(this.rows.size(), this.headerRows);
        for (int i2 = n2; i2 < n3; ++i2) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(i2);
            if (pdfPRow == null) continue;
            f2 += pdfPRow.getMaxHeights();
        }
        return f2;
    }

    public boolean deleteRow(int n2) {
        PdfPRow pdfPRow;
        if (n2 < 0 || n2 >= this.rows.size()) {
            return false;
        }
        if (this.totalWidth > 0.0f && (pdfPRow = (PdfPRow)this.rows.get(n2)) != null) {
            this.totalHeight -= pdfPRow.getMaxHeights();
        }
        this.rows.remove(n2);
        if (n2 < this.headerRows) {
            --this.headerRows;
            if (n2 >= this.headerRows - this.footerRows) {
                --this.footerRows;
            }
        }
        return true;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public void deleteBodyRows() {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < this.headerRows; ++i2) {
            arrayList.add(this.rows.get(i2));
        }
        this.rows = arrayList;
        this.totalHeight = 0.0f;
        if (this.totalWidth > 0.0f) {
            this.totalHeight = this.getHeaderHeight();
        }
    }

    public int getNumberOfColumns() {
        return this.relativeWidths.length;
    }

    public int getHeaderRows() {
        return this.headerRows;
    }

    public void setHeaderRows(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.headerRows = n2;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public int type() {
        return 23;
    }

    public boolean isContent() {
        return true;
    }

    public boolean isNestable() {
        return true;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setWidthPercentage(float f2) {
        this.widthPercentage = f2;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n2) {
        this.horizontalAlignment = n2;
    }

    public PdfPRow getRow(int n2) {
        return (PdfPRow)this.rows.get(n2);
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public ArrayList getRows(int n2, int n3) {
        int n4;
        ArrayList<PdfPRow> arrayList = new ArrayList<PdfPRow>();
        if (n2 < 0 || n3 > this.size()) {
            return arrayList;
        }
        PdfPRow pdfPRow = this.adjustCellsInRow(n2, n3);
        int n5 = 0;
        while (n5 < this.getNumberOfColumns()) {
            n4 = n2;
            while (this.rowSpanAbove(n4--, n5)) {
                PdfPCell pdfPCell;
                PdfPRow pdfPRow2 = this.getRow(n4);
                if (pdfPRow2 == null || (pdfPCell = pdfPRow2.getCells()[n5]) == null) continue;
                pdfPRow.getCells()[n5] = new PdfPCell(pdfPCell);
                float f2 = 0.0f;
                int n6 = Math.min(n4 + pdfPCell.getRowspan(), n3);
                for (int i2 = n2 + 1; i2 < n6; ++i2) {
                    f2 += this.getRowHeight(i2);
                }
                pdfPRow.setExtraHeight(n5, f2);
                float f3 = this.getRowspanHeight(n4, n5) - this.getRowHeight(n2) - f2;
                pdfPRow.getCells()[n5].consumeHeight(f3);
            }
            PdfPCell pdfPCell = pdfPRow.getCells()[n5];
            if (pdfPCell == null) {
                ++n5;
                continue;
            }
            n5 += pdfPCell.getColspan();
        }
        arrayList.add(pdfPRow);
        for (n4 = n2 + 1; n4 < n3; ++n4) {
            arrayList.add(this.adjustCellsInRow(n4, n3));
        }
        return arrayList;
    }

    protected PdfPRow adjustCellsInRow(int n2, int n3) {
        PdfPRow pdfPRow = new PdfPRow(this.getRow(n2));
        pdfPRow.initExtraHeights();
        PdfPCell[] pdfPCellArray = pdfPRow.getCells();
        for (int i2 = 0; i2 < pdfPCellArray.length; ++i2) {
            PdfPCell pdfPCell = pdfPCellArray[i2];
            if (pdfPCell == null || pdfPCell.getRowspan() == 1) continue;
            int n4 = Math.min(n3, n2 + pdfPCell.getRowspan());
            float f2 = 0.0f;
            for (int i3 = n2 + 1; i3 < n4; ++i3) {
                f2 += this.getRowHeight(i3);
            }
            pdfPRow.setExtraHeight(i2, f2);
        }
        return pdfPRow;
    }

    public void setTableEvent(PdfPTableEvent pdfPTableEvent) {
        if (pdfPTableEvent == null) {
            this.tableEvent = null;
        } else if (this.tableEvent == null) {
            this.tableEvent = pdfPTableEvent;
        } else if (this.tableEvent instanceof PdfPTableEventForwarder) {
            ((PdfPTableEventForwarder)this.tableEvent).addTableEvent(pdfPTableEvent);
        } else {
            PdfPTableEventForwarder pdfPTableEventForwarder = new PdfPTableEventForwarder();
            pdfPTableEventForwarder.addTableEvent(this.tableEvent);
            pdfPTableEventForwarder.addTableEvent(pdfPTableEvent);
            this.tableEvent = pdfPTableEventForwarder;
        }
    }

    public PdfPTableEvent getTableEvent() {
        return this.tableEvent;
    }

    public float[] getAbsoluteWidths() {
        return this.absoluteWidths;
    }

    float[][] getEventWidths(float f2, int n2, int n3, boolean bl) {
        if (bl) {
            n2 = Math.max(n2, this.headerRows);
            n3 = Math.max(n3, this.headerRows);
        }
        float[][] fArrayArray = new float[(bl ? this.headerRows : 0) + n3 - n2][];
        if (this.isColspan) {
            int n4 = 0;
            if (bl) {
                for (int i2 = 0; i2 < this.headerRows; ++i2) {
                    PdfPRow pdfPRow = (PdfPRow)this.rows.get(i2);
                    if (pdfPRow == null) {
                        ++n4;
                        continue;
                    }
                    fArrayArray[n4++] = pdfPRow.getEventWidth(f2);
                }
            }
            while (n2 < n3) {
                PdfPRow pdfPRow = (PdfPRow)this.rows.get(n2);
                if (pdfPRow == null) {
                    ++n4;
                } else {
                    fArrayArray[n4++] = pdfPRow.getEventWidth(f2);
                }
                ++n2;
            }
        } else {
            int n5;
            int n6 = this.getNumberOfColumns();
            float[] fArray = new float[n6 + 1];
            fArray[0] = f2;
            for (n5 = 0; n5 < n6; ++n5) {
                fArray[n5 + 1] = fArray[n5] + this.absoluteWidths[n5];
            }
            for (n5 = 0; n5 < fArrayArray.length; ++n5) {
                fArrayArray[n5] = fArray;
            }
        }
        return fArrayArray;
    }

    public boolean isSkipFirstHeader() {
        return this.skipFirstHeader;
    }

    public boolean isSkipLastFooter() {
        return this.skipLastFooter;
    }

    public void setSkipFirstHeader(boolean bl) {
        this.skipFirstHeader = bl;
    }

    public void setSkipLastFooter(boolean bl) {
        this.skipLastFooter = bl;
    }

    public void setRunDirection(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.runDirection = n2;
                break;
            }
            default: {
                throw new RuntimeException("Invalid run direction: " + n2);
            }
        }
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public boolean isLockedWidth() {
        return this.lockedWidth;
    }

    public void setLockedWidth(boolean bl) {
        this.lockedWidth = bl;
    }

    public boolean isSplitRows() {
        return this.splitRows;
    }

    public void setSplitRows(boolean bl) {
        this.splitRows = bl;
    }

    public void setSpacingBefore(float f2) {
        this.spacingBefore = f2;
    }

    public void setSpacingAfter(float f2) {
        this.spacingAfter = f2;
    }

    public float spacingBefore() {
        return this.spacingBefore;
    }

    public float spacingAfter() {
        return this.spacingAfter;
    }

    public boolean isExtendLastRow() {
        return this.extendLastRow;
    }

    public void setExtendLastRow(boolean bl) {
        this.extendLastRow = bl;
    }

    public boolean isHeadersInEvent() {
        return this.headersInEvent;
    }

    public void setHeadersInEvent(boolean bl) {
        this.headersInEvent = bl;
    }

    public boolean isSplitLate() {
        return this.splitLate;
    }

    public void setSplitLate(boolean bl) {
        this.splitLate = bl;
    }

    public void setKeepTogether(boolean bl) {
        this.keepTogether = bl;
    }

    public boolean getKeepTogether() {
        return this.keepTogether;
    }

    public int getFooterRows() {
        return this.footerRows;
    }

    public void setFooterRows(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.footerRows = n2;
    }

    public void completeRow() {
        while (!this.rowCompleted) {
            this.addCell(this.defaultCell);
        }
    }

    public void flushContent() {
        this.deleteBodyRows();
        this.setSkipFirstHeader(true);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
    }
}

