/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.TextProvidingRenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.pdf.parser.Vector;

public class SimpleTextExtractingPdfContentRenderListener
implements TextProvidingRenderListener {
    private Vector lastStart;
    private Vector lastEnd;
    private StringBuffer result;

    public SimpleTextExtractingPdfContentRenderListener() {
        this.reset();
    }

    @Override
    public void reset() {
        this.result = new StringBuffer();
    }

    @Override
    public void beginTextBlock() {
    }

    @Override
    public void endTextBlock() {
    }

    @Override
    public String getResultantText() {
        return this.result.toString();
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        float spacing;
        boolean firstRender = this.result.length() == 0;
        boolean hardReturn = false;
        Vector start = renderInfo.getStartPoint();
        Vector end = renderInfo.getEndPoint();
        if (!firstRender) {
            float sameLineThreshold;
            Vector x0 = start;
            Vector x2 = this.lastEnd;
            Vector x1 = this.lastStart;
            float dist = x2.subtract(x1).cross(x1.subtract(x0)).lengthSquared() / x2.subtract(x1).lengthSquared();
            if (dist > (sameLineThreshold = 1.0f)) {
                hardReturn = true;
            }
        }
        if (hardReturn) {
            this.result.append('\n');
        } else if (!firstRender && this.result.charAt(this.result.length() - 1) != ' ' && renderInfo.getText().charAt(0) != ' ' && (spacing = this.lastEnd.subtract(start).length()) > renderInfo.getSingleSpaceWidth() / 2.0f) {
            this.result.append(' ');
        }
        this.result.append(renderInfo.getText());
        this.lastStart = start;
        this.lastEnd = end;
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
    }
}

