/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseField;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.FontSelector;
import com.itextpdf.text.pdf.GrayColor;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfAppearance;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBorderDictionary;
import com.itextpdf.text.pdf.PdfDashPattern;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;

public class TextField
extends BaseField {
    private String defaultText;
    private String[] choices;
    private String[] choiceExports;
    private ArrayList<Integer> choiceSelections = new ArrayList();
    private int topFirst;
    private float extraMarginLeft;
    private float extraMarginTop;
    private ArrayList<BaseFont> substitutionFonts;
    private BaseFont extensionFont;

    public TextField(PdfWriter writer, Rectangle box, String fieldName) {
        super(writer, box, fieldName);
    }

    private static boolean checkRTL(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        char[] cc = text.toCharArray();
        int k2 = 0;
        while (k2 < cc.length) {
            char c2 = cc[k2];
            if (c2 >= '\u0590' && c2 < '\u0780') {
                return true;
            }
            ++k2;
        }
        return false;
    }

    private static void changeFontSize(Phrase p2, float size) {
        int k2 = 0;
        while (k2 < p2.size()) {
            ((Chunk)p2.get(k2)).getFont().setSize(size);
            ++k2;
        }
    }

    private Phrase composePhrase(String text, BaseFont ufont, BaseColor color, float fontSize) {
        Phrase phrase = null;
        if (this.extensionFont == null && (this.substitutionFonts == null || this.substitutionFonts.isEmpty())) {
            phrase = new Phrase(new Chunk(text, new Font(ufont, fontSize, 0, color)));
        } else {
            FontSelector fs = new FontSelector();
            fs.addFont(new Font(ufont, fontSize, 0, color));
            if (this.extensionFont != null) {
                fs.addFont(new Font(this.extensionFont, fontSize, 0, color));
            }
            if (this.substitutionFonts != null) {
                int k2 = 0;
                while (k2 < this.substitutionFonts.size()) {
                    fs.addFont(new Font(this.substitutionFonts.get(k2), fontSize, 0, color));
                    ++k2;
                }
            }
            phrase = fs.process(text);
        }
        return phrase;
    }

    public static String removeCRLF(String text) {
        if (text.indexOf(10) >= 0 || text.indexOf(13) >= 0) {
            char[] p2 = text.toCharArray();
            StringBuffer sb = new StringBuffer(p2.length);
            int k2 = 0;
            while (k2 < p2.length) {
                char c2 = p2[k2];
                if (c2 == '\n') {
                    sb.append(' ');
                } else if (c2 == '\r') {
                    sb.append(' ');
                    if (k2 < p2.length - 1 && p2[k2 + 1] == '\n') {
                        ++k2;
                    }
                } else {
                    sb.append(c2);
                }
                ++k2;
            }
            return sb.toString();
        }
        return text;
    }

    public static String obfuscatePassword(String text) {
        char[] pchar = new char[text.length()];
        int i2 = 0;
        while (i2 < text.length()) {
            pchar[i2] = 42;
            ++i2;
        }
        return new String(pchar);
    }

    public PdfAppearance getAppearance() throws IOException, DocumentException {
        PdfAppearance app = this.getBorderAppearance();
        app.beginVariableText();
        if (this.text == null || this.text.length() == 0) {
            app.endVariableText();
            return app;
        }
        boolean borderExtra = this.borderStyle == 2 || this.borderStyle == 3;
        float h2 = this.box.getHeight() - this.borderWidth * 2.0f - this.extraMarginTop;
        float bw2 = this.borderWidth;
        if (borderExtra) {
            h2 -= this.borderWidth * 2.0f;
            bw2 *= 2.0f;
        }
        float offsetX = Math.max(bw2, 1.0f);
        float offX = Math.min(bw2, offsetX);
        app.saveState();
        app.rectangle(offX, offX, this.box.getWidth() - 2.0f * offX, this.box.getHeight() - 2.0f * offX);
        app.clip();
        app.newPath();
        String ptext = (this.options & 0x2000) != 0 ? TextField.obfuscatePassword(this.text) : ((this.options & 0x1000) == 0 ? TextField.removeCRLF(this.text) : this.text);
        BaseFont ufont = this.getRealFont();
        BaseColor fcolor = this.textColor == null ? GrayColor.GRAYBLACK : this.textColor;
        int rtl = TextField.checkRTL(ptext) ? 2 : 1;
        float usize = this.fontSize;
        Phrase phrase = this.composePhrase(ptext, ufont, fcolor, usize);
        if ((this.options & 0x1000) != 0) {
            float width = this.box.getWidth() - 4.0f * offsetX - this.extraMarginLeft;
            float factor = ufont.getFontDescriptor(8, 1.0f) - ufont.getFontDescriptor(6, 1.0f);
            ColumnText ct = new ColumnText(null);
            if (usize == 0.0f) {
                usize = h2 / factor;
                if (usize > 4.0f) {
                    if (usize > 12.0f) {
                        usize = 12.0f;
                    }
                    float step = Math.max((usize - 4.0f) / 10.0f, 0.2f);
                    ct.setSimpleColumn(0.0f, -h2, width, 0.0f);
                    ct.setAlignment(this.alignment);
                    ct.setRunDirection(rtl);
                    while (usize > 4.0f) {
                        ct.setYLine(0.0f);
                        TextField.changeFontSize(phrase, usize);
                        ct.setText(phrase);
                        ct.setLeading(factor * usize);
                        int status = ct.go(true);
                        if ((status & 2) == 0) break;
                        usize -= step;
                    }
                }
                if (usize < 4.0f) {
                    usize = 4.0f;
                }
            }
            TextField.changeFontSize(phrase, usize);
            ct.setCanvas(app);
            float leading = usize * factor;
            float offsetY = offsetX + h2 - ufont.getFontDescriptor(8, usize);
            ct.setSimpleColumn(this.extraMarginLeft + 2.0f * offsetX, -20000.0f, this.box.getWidth() - 2.0f * offsetX, offsetY + leading);
            ct.setLeading(leading);
            ct.setAlignment(this.alignment);
            ct.setRunDirection(rtl);
            ct.setText(phrase);
            ct.go();
        } else {
            if (usize == 0.0f) {
                float maxCalculatedSize = h2 / (ufont.getFontDescriptor(7, 1.0f) - ufont.getFontDescriptor(6, 1.0f));
                TextField.changeFontSize(phrase, 1.0f);
                float wd = ColumnText.getWidth(phrase, rtl, 0);
                usize = wd == 0.0f ? maxCalculatedSize : Math.min(maxCalculatedSize, (this.box.getWidth() - this.extraMarginLeft - 4.0f * offsetX) / wd);
                if (usize < 4.0f) {
                    usize = 4.0f;
                }
            }
            TextField.changeFontSize(phrase, usize);
            float offsetY = offX + (this.box.getHeight() - 2.0f * offX - ufont.getFontDescriptor(1, usize)) / 2.0f;
            if (offsetY < offX) {
                offsetY = offX;
            }
            if (offsetY - offX < -ufont.getFontDescriptor(3, usize)) {
                float ny = -ufont.getFontDescriptor(3, usize) + offX;
                float dy = this.box.getHeight() - offX - ufont.getFontDescriptor(1, usize);
                offsetY = Math.min(ny, Math.max(offsetY, dy));
            }
            if ((this.options & 0x1000000) != 0 && this.maxCharacterLength > 0) {
                int textLen = Math.min(this.maxCharacterLength, ptext.length());
                int position = 0;
                if (this.alignment == 2) {
                    position = this.maxCharacterLength - textLen;
                } else if (this.alignment == 1) {
                    position = (this.maxCharacterLength - textLen) / 2;
                }
                float step = (this.box.getWidth() - this.extraMarginLeft) / (float)this.maxCharacterLength;
                float start = step / 2.0f + (float)position * step;
                if (this.textColor == null) {
                    app.setGrayFill(0.0f);
                } else {
                    app.setColorFill(this.textColor);
                }
                app.beginText();
                int k2 = 0;
                while (k2 < phrase.size()) {
                    Chunk ck = (Chunk)phrase.get(k2);
                    BaseFont bf = ck.getFont().getBaseFont();
                    app.setFontAndSize(bf, usize);
                    StringBuffer sb = ck.append("");
                    int j2 = 0;
                    while (j2 < sb.length()) {
                        String c2 = sb.substring(j2, j2 + 1);
                        float wd = bf.getWidthPoint(c2, usize);
                        app.setTextMatrix(this.extraMarginLeft + start - wd / 2.0f, offsetY - this.extraMarginTop);
                        app.showText(c2);
                        start += step;
                        ++j2;
                    }
                    ++k2;
                }
                app.endText();
            } else {
                float x;
                switch (this.alignment) {
                    case 2: {
                        x = this.extraMarginLeft + this.box.getWidth() - 2.0f * offsetX;
                        break;
                    }
                    case 1: {
                        x = this.extraMarginLeft + this.box.getWidth() / 2.0f;
                        break;
                    }
                    default: {
                        x = this.extraMarginLeft + 2.0f * offsetX;
                    }
                }
                ColumnText.showTextAligned(app, this.alignment, phrase, x, offsetY - this.extraMarginTop, 0.0f, rtl, 0);
            }
        }
        app.restoreState();
        app.endVariableText();
        return app;
    }

    PdfAppearance getListAppearance() throws IOException, DocumentException {
        PdfAppearance app = this.getBorderAppearance();
        if (this.choices == null || this.choices.length == 0) {
            return app;
        }
        app.beginVariableText();
        int topChoice = this.getTopChoice();
        BaseFont ufont = this.getRealFont();
        float usize = this.fontSize;
        if (usize == 0.0f) {
            usize = 12.0f;
        }
        boolean borderExtra = this.borderStyle == 2 || this.borderStyle == 3;
        float h2 = this.box.getHeight() - this.borderWidth * 2.0f;
        float offsetX = this.borderWidth;
        if (borderExtra) {
            h2 -= this.borderWidth * 2.0f;
            offsetX *= 2.0f;
        }
        float leading = ufont.getFontDescriptor(8, usize) - ufont.getFontDescriptor(6, usize);
        int maxFit = (int)(h2 / leading) + 1;
        int first = 0;
        int last = 0;
        first = topChoice;
        last = first + maxFit;
        if (last > this.choices.length) {
            last = this.choices.length;
        }
        this.topFirst = first;
        app.saveState();
        app.rectangle(offsetX, offsetX, this.box.getWidth() - 2.0f * offsetX, this.box.getHeight() - 2.0f * offsetX);
        app.clip();
        app.newPath();
        BaseColor fcolor = this.textColor == null ? GrayColor.GRAYBLACK : this.textColor;
        app.setColorFill(new BaseColor(10, 36, 106));
        int curVal = 0;
        while (curVal < this.choiceSelections.size()) {
            int curChoice = this.choiceSelections.get(curVal);
            if (curChoice >= first && curChoice <= last) {
                app.rectangle(offsetX, offsetX + h2 - (float)(curChoice - first + 1) * leading, this.box.getWidth() - 2.0f * offsetX, leading);
                app.fill();
            }
            ++curVal;
        }
        float xp = offsetX * 2.0f;
        float yp = offsetX + h2 - ufont.getFontDescriptor(8, usize);
        int idx = first;
        while (idx < last) {
            String ptext = this.choices[idx];
            int rtl = TextField.checkRTL(ptext) ? 2 : 1;
            ptext = TextField.removeCRLF(ptext);
            GrayColor textCol = this.choiceSelections.contains(new Integer(idx)) ? GrayColor.GRAYWHITE : fcolor;
            Phrase phrase = this.composePhrase(ptext, ufont, textCol, usize);
            ColumnText.showTextAligned(app, 0, phrase, xp, yp, 0.0f, rtl, 0);
            ++idx;
            yp -= leading;
        }
        app.restoreState();
        app.endVariableText();
        return app;
    }

    public PdfFormField getTextField() throws IOException, DocumentException {
        if (this.maxCharacterLength <= 0) {
            this.options &= 0xFEFFFFFF;
        }
        if ((this.options & 0x1000000) != 0) {
            this.options &= 0xFFFFEFFF;
        }
        PdfFormField field = PdfFormField.createTextField(this.writer, false, false, this.maxCharacterLength);
        field.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        switch (this.alignment) {
            case 1: {
                field.setQuadding(1);
                break;
            }
            case 2: {
                field.setQuadding(2);
            }
        }
        if (this.rotation != 0) {
            field.setMKRotation(this.rotation);
        }
        if (this.fieldName != null) {
            field.setFieldName(this.fieldName);
            if (!"".equals(this.text)) {
                field.setValueAsString(this.text);
            }
            if (this.defaultText != null) {
                field.setDefaultValueAsString(this.defaultText);
            }
            if ((this.options & 1) != 0) {
                field.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                field.setFieldFlags(2);
            }
            if ((this.options & 0x1000) != 0) {
                field.setFieldFlags(4096);
            }
            if ((this.options & 0x800000) != 0) {
                field.setFieldFlags(0x800000);
            }
            if ((this.options & 0x2000) != 0) {
                field.setFieldFlags(8192);
            }
            if ((this.options & 0x100000) != 0) {
                field.setFieldFlags(0x100000);
            }
            if ((this.options & 0x400000) != 0) {
                field.setFieldFlags(0x400000);
            }
            if ((this.options & 0x1000000) != 0) {
                field.setFieldFlags(0x1000000);
            }
        }
        field.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance tp = this.getAppearance();
        field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, tp);
        PdfAppearance da = (PdfAppearance)tp.getDuplicate();
        da.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            da.setGrayFill(0.0f);
        } else {
            da.setColorFill(this.textColor);
        }
        field.setDefaultAppearanceString(da);
        if (this.borderColor != null) {
            field.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            field.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                field.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                field.setFlags(36);
                break;
            }
            default: {
                field.setFlags(4);
            }
        }
        return field;
    }

    public PdfFormField getComboField() throws IOException, DocumentException {
        return this.getChoiceField(false);
    }

    public PdfFormField getListField() throws IOException, DocumentException {
        return this.getChoiceField(true);
    }

    private int getTopChoice() {
        if (this.choiceSelections == null || this.choiceSelections.size() == 0) {
            return 0;
        }
        Integer firstValue = this.choiceSelections.get(0);
        if (firstValue == null) {
            return 0;
        }
        int topChoice = 0;
        if (this.choices != null) {
            topChoice = firstValue;
            topChoice = Math.min(topChoice, this.choices.length);
            topChoice = Math.max(0, topChoice);
        }
        return topChoice;
    }

    protected PdfFormField getChoiceField(boolean isList) throws IOException, DocumentException {
        PdfAppearance tp;
        this.options &= 0xFEFFEFFF;
        String[] uchoices = this.choices;
        if (uchoices == null) {
            uchoices = new String[]{};
        }
        int topChoice = this.getTopChoice();
        if (this.text == null) {
            this.text = "";
        }
        if (topChoice >= 0) {
            this.text = uchoices[topChoice];
        }
        PdfFormField field = null;
        String[][] mix = null;
        if (this.choiceExports == null) {
            field = isList ? PdfFormField.createList(this.writer, uchoices, topChoice) : PdfFormField.createCombo(this.writer, (this.options & 0x40000) != 0, uchoices, topChoice);
        } else {
            mix = new String[uchoices.length][2];
            int k2 = 0;
            while (k2 < mix.length) {
                String string = uchoices[k2];
                mix[k2][1] = string;
                mix[k2][0] = string;
                ++k2;
            }
            int top = Math.min(uchoices.length, this.choiceExports.length);
            int k3 = 0;
            while (k3 < top) {
                if (this.choiceExports[k3] != null) {
                    mix[k3][0] = this.choiceExports[k3];
                }
                ++k3;
            }
            field = isList ? PdfFormField.createList(this.writer, mix, topChoice) : PdfFormField.createCombo(this.writer, (this.options & 0x40000) != 0, mix, topChoice);
        }
        field.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        if (this.rotation != 0) {
            field.setMKRotation(this.rotation);
        }
        if (this.fieldName != null) {
            field.setFieldName(this.fieldName);
            if (uchoices.length > 0) {
                if (mix != null) {
                    if (this.choiceSelections.size() < 2) {
                        field.setValueAsString(mix[topChoice][0]);
                        field.setDefaultValueAsString(mix[topChoice][0]);
                    } else {
                        this.writeMultipleValues(field, mix);
                    }
                } else if (this.choiceSelections.size() < 2) {
                    field.setValueAsString(this.text);
                    field.setDefaultValueAsString(this.text);
                } else {
                    this.writeMultipleValues(field, null);
                }
            }
            if ((this.options & 1) != 0) {
                field.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                field.setFieldFlags(2);
            }
            if ((this.options & 0x400000) != 0) {
                field.setFieldFlags(0x400000);
            }
            if ((this.options & 0x200000) != 0) {
                field.setFieldFlags(0x200000);
            }
        }
        field.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        if (isList) {
            tp = this.getListAppearance();
            if (this.topFirst > 0) {
                field.put(PdfName.TI, new PdfNumber(this.topFirst));
            }
        } else {
            tp = this.getAppearance();
        }
        field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, tp);
        PdfAppearance da = (PdfAppearance)tp.getDuplicate();
        da.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            da.setGrayFill(0.0f);
        } else {
            da.setColorFill(this.textColor);
        }
        field.setDefaultAppearanceString(da);
        if (this.borderColor != null) {
            field.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            field.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                field.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                field.setFlags(36);
                break;
            }
            default: {
                field.setFlags(4);
            }
        }
        return field;
    }

    private void writeMultipleValues(PdfFormField field, String[][] mix) {
        PdfArray indexes = new PdfArray();
        PdfArray values = new PdfArray();
        int i2 = 0;
        while (i2 < this.choiceSelections.size()) {
            int idx = this.choiceSelections.get(i2);
            indexes.add(new PdfNumber(idx));
            if (mix != null) {
                values.add(new PdfString(mix[idx][0]));
            } else if (this.choices != null) {
                values.add(new PdfString(this.choices[idx]));
            }
            ++i2;
        }
        field.put(PdfName.V, values);
        field.put(PdfName.I, indexes);
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public void setChoices(String[] choices) {
        this.choices = choices;
    }

    public String[] getChoiceExports() {
        return this.choiceExports;
    }

    public void setChoiceExports(String[] choiceExports) {
        this.choiceExports = choiceExports;
    }

    public int getChoiceSelection() {
        return this.getTopChoice();
    }

    public ArrayList<Integer> getChoiceSelections() {
        return this.choiceSelections;
    }

    public void setChoiceSelection(int choiceSelection) {
        this.choiceSelections = new ArrayList();
        this.choiceSelections.add(new Integer(choiceSelection));
    }

    public void addChoiceSelection(int selection) {
        if ((this.options & 0x200000) != 0) {
            this.choiceSelections.add(new Integer(selection));
        }
    }

    public void setChoiceSelections(ArrayList<Integer> selections) {
        if (selections != null) {
            this.choiceSelections = new ArrayList<Integer>(selections);
            if (this.choiceSelections.size() > 1 && (this.options & 0x200000) == 0) {
                while (this.choiceSelections.size() > 1) {
                    this.choiceSelections.remove(1);
                }
            }
        } else {
            this.choiceSelections.clear();
        }
    }

    int getTopFirst() {
        return this.topFirst;
    }

    public void setExtraMargin(float extraMarginLeft, float extraMarginTop) {
        this.extraMarginLeft = extraMarginLeft;
        this.extraMarginTop = extraMarginTop;
    }

    public ArrayList<BaseFont> getSubstitutionFonts() {
        return this.substitutionFonts;
    }

    public void setSubstitutionFonts(ArrayList<BaseFont> substitutionFonts) {
        this.substitutionFonts = substitutionFonts;
    }

    public BaseFont getExtensionFont() {
        return this.extensionFont;
    }

    public void setExtensionFont(BaseFont extensionFont) {
        this.extensionFont = extensionFont;
    }
}

