/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.html.Markup;
import com.itextpdf.text.pdf.BaseFont;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FontFactoryImp
implements FontProvider {
    private Hashtable<String, String> trueTypeFonts = new Hashtable();
    private static String[] TTFamilyOrder = new String[]{"3", "1", "1033", "3", "0", "1033", "1", "0", "0", "0", "3", "0"};
    private Hashtable<String, ArrayList<String>> fontFamilies = new Hashtable();
    public String defaultEncoding = "Cp1252";
    public boolean defaultEmbedding = false;

    public FontFactoryImp() {
        this.trueTypeFonts.put("Courier".toLowerCase(), "Courier");
        this.trueTypeFonts.put("Courier-Bold".toLowerCase(), "Courier-Bold");
        this.trueTypeFonts.put("Courier-Oblique".toLowerCase(), "Courier-Oblique");
        this.trueTypeFonts.put("Courier-BoldOblique".toLowerCase(), "Courier-BoldOblique");
        this.trueTypeFonts.put("Helvetica".toLowerCase(), "Helvetica");
        this.trueTypeFonts.put("Helvetica-Bold".toLowerCase(), "Helvetica-Bold");
        this.trueTypeFonts.put("Helvetica-Oblique".toLowerCase(), "Helvetica-Oblique");
        this.trueTypeFonts.put("Helvetica-BoldOblique".toLowerCase(), "Helvetica-BoldOblique");
        this.trueTypeFonts.put("Symbol".toLowerCase(), "Symbol");
        this.trueTypeFonts.put("Times-Roman".toLowerCase(), "Times-Roman");
        this.trueTypeFonts.put("Times-Bold".toLowerCase(), "Times-Bold");
        this.trueTypeFonts.put("Times-Italic".toLowerCase(), "Times-Italic");
        this.trueTypeFonts.put("Times-BoldItalic".toLowerCase(), "Times-BoldItalic");
        this.trueTypeFonts.put("ZapfDingbats".toLowerCase(), "ZapfDingbats");
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("Courier");
        tmp.add("Courier-Bold");
        tmp.add("Courier-Oblique");
        tmp.add("Courier-BoldOblique");
        this.fontFamilies.put("Courier".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("Helvetica");
        tmp.add("Helvetica-Bold");
        tmp.add("Helvetica-Oblique");
        tmp.add("Helvetica-BoldOblique");
        this.fontFamilies.put("Helvetica".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("Symbol");
        this.fontFamilies.put("Symbol".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("Times-Roman");
        tmp.add("Times-Bold");
        tmp.add("Times-Italic");
        tmp.add("Times-BoldItalic");
        this.fontFamilies.put("Times".toLowerCase(), tmp);
        this.fontFamilies.put("Times-Roman".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("ZapfDingbats");
        this.fontFamilies.put("ZapfDingbats".toLowerCase(), tmp);
    }

    @Override
    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style, BaseColor color) {
        return this.getFont(fontname, encoding, embedded, size, style, color, true);
    }

    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style, BaseColor color, boolean cached) {
        if (fontname == null) {
            return new Font(Font.FontFamily.UNDEFINED, size, style, color);
        }
        String lowercasefontname = fontname.toLowerCase();
        ArrayList<String> tmp = this.fontFamilies.get(lowercasefontname);
        if (tmp != null) {
            int s2 = style == -1 ? 0 : style;
            int fs = 0;
            boolean found = false;
            Iterator<String> iterator = tmp.iterator();
            while (iterator.hasNext()) {
                String string;
                String f2 = string = iterator.next();
                String lcf = f2.toLowerCase();
                fs = 0;
                if (lcf.toLowerCase().indexOf("bold") != -1) {
                    fs |= 1;
                }
                if (lcf.toLowerCase().indexOf("italic") != -1 || lcf.toLowerCase().indexOf("oblique") != -1) {
                    fs |= 2;
                }
                if ((s2 & 3) != fs) continue;
                fontname = f2;
                found = true;
                break;
            }
            if (style != -1 && found) {
                style &= ~fs;
            }
        }
        BaseFont basefont = null;
        try {
            try {
                basefont = BaseFont.createFont(fontname, encoding, embedded, cached, null, null, true);
            }
            catch (DocumentException fs) {
                // empty catch block
            }
            if (basefont == null) {
                if ((fontname = this.trueTypeFonts.get(fontname.toLowerCase())) == null) {
                    return new Font(Font.FontFamily.UNDEFINED, size, style, color);
                }
                basefont = BaseFont.createFont(fontname, encoding, embedded, cached, null, null);
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        catch (IOException ioe) {
            return new Font(Font.FontFamily.UNDEFINED, size, style, color);
        }
        catch (NullPointerException npe) {
            return new Font(Font.FontFamily.UNDEFINED, size, style, color);
        }
        return new Font(basefont, size, style, color);
    }

    public Font getFont(Properties attributes) {
        String fontname = null;
        String encoding = this.defaultEncoding;
        boolean embedded = this.defaultEmbedding;
        float size = -1.0f;
        int style = 0;
        BaseColor color = null;
        String value = attributes.getProperty("style");
        if (value != null && value.length() > 0) {
            Properties styleAttributes = Markup.parseAttributes(value);
            if (styleAttributes.isEmpty()) {
                attributes.put("style", value);
            } else {
                fontname = styleAttributes.getProperty("font-family");
                if (fontname != null) {
                    while (fontname.indexOf(44) != -1) {
                        String tmp = fontname.substring(0, fontname.indexOf(44));
                        fontname = this.isRegistered(tmp) ? tmp : fontname.substring(fontname.indexOf(44) + 1);
                    }
                }
                if ((value = styleAttributes.getProperty("font-size")) != null) {
                    size = Markup.parseLength(value);
                }
                if ((value = styleAttributes.getProperty("font-weight")) != null) {
                    style |= Font.getStyleValue(value);
                }
                if ((value = styleAttributes.getProperty("font-style")) != null) {
                    style |= Font.getStyleValue(value);
                }
                if ((value = styleAttributes.getProperty("color")) != null) {
                    color = Markup.decodeColor(value);
                }
                attributes.putAll((Map<?, ?>)styleAttributes);
            }
        }
        if ((value = attributes.getProperty("encoding")) != null) {
            encoding = value;
        }
        if ("true".equals(attributes.getProperty("embedded"))) {
            embedded = true;
        }
        if ((value = attributes.getProperty("font")) != null) {
            fontname = value;
        }
        if ((value = attributes.getProperty("size")) != null) {
            size = Markup.parseLength(value);
        }
        if ((value = attributes.getProperty("style")) != null) {
            style |= Font.getStyleValue(value);
        }
        if ((value = attributes.getProperty("fontstyle")) != null) {
            style |= Font.getStyleValue(value);
        }
        String r2 = attributes.getProperty("red");
        String g2 = attributes.getProperty("green");
        String b2 = attributes.getProperty("blue");
        if (r2 != null || g2 != null || b2 != null) {
            int red = 0;
            int green = 0;
            int blue = 0;
            if (r2 != null) {
                red = Integer.parseInt(r2);
            }
            if (g2 != null) {
                green = Integer.parseInt(g2);
            }
            if (b2 != null) {
                blue = Integer.parseInt(b2);
            }
            color = new BaseColor(red, green, blue);
        } else {
            value = attributes.getProperty("color");
            if (value != null) {
                color = Markup.decodeColor(value);
            }
        }
        if (fontname == null) {
            return this.getFont(null, encoding, embedded, size, style, color);
        }
        return this.getFont(fontname, encoding, embedded, size, style, color);
    }

    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style) {
        return this.getFont(fontname, encoding, embedded, size, style, null);
    }

    public Font getFont(String fontname, String encoding, boolean embedded, float size) {
        return this.getFont(fontname, encoding, embedded, size, -1, null);
    }

    public Font getFont(String fontname, String encoding, boolean embedded) {
        return this.getFont(fontname, encoding, embedded, -1.0f, -1, null);
    }

    public Font getFont(String fontname, String encoding, float size, int style, BaseColor color) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, size, style, color);
    }

    public Font getFont(String fontname, String encoding, float size, int style) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, size, style, null);
    }

    public Font getFont(String fontname, String encoding, float size) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, size, -1, null);
    }

    public Font getFont(String fontname, float size, BaseColor color) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, -1, color);
    }

    public Font getFont(String fontname, String encoding) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, -1.0f, -1, null);
    }

    public Font getFont(String fontname, float size, int style, BaseColor color) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, style, color);
    }

    public Font getFont(String fontname, float size, int style) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, style, null);
    }

    public Font getFont(String fontname, float size) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, -1, null);
    }

    public Font getFont(String fontname) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, -1.0f, -1, null);
    }

    public void registerFamily(String familyName, String fullName, String path) {
        ArrayList<String> tmp;
        if (path != null) {
            this.trueTypeFonts.put(fullName, path);
        }
        if ((tmp = this.fontFamilies.get(familyName)) == null) {
            tmp = new ArrayList();
            tmp.add(fullName);
            this.fontFamilies.put(familyName, tmp);
        } else {
            int fullNameLength = fullName.length();
            boolean inserted = false;
            int j2 = 0;
            while (j2 < tmp.size()) {
                if (tmp.get(j2).length() >= fullNameLength) {
                    tmp.add(j2, fullName);
                    inserted = true;
                    break;
                }
                ++j2;
            }
            if (!inserted) {
                tmp.add(fullName);
            }
        }
    }

    public void register(String path) {
        this.register(path, null);
    }

    public void register(String path, String alias) {
        try {
            if (path.toLowerCase().endsWith(".ttf") || path.toLowerCase().endsWith(".otf") || path.toLowerCase().indexOf(".ttc,") > 0) {
                String[] name;
                int n2;
                int n3;
                String[][] stringArray;
                String[][] names;
                Object[] allNames = BaseFont.getAllFontNames(path, "Cp1252", null);
                this.trueTypeFonts.put(((String)allNames[0]).toLowerCase(), path);
                if (alias != null) {
                    this.trueTypeFonts.put(alias.toLowerCase(), path);
                }
                String[][] stringArray2 = names = (String[][])allNames[2];
                int n4 = names.length;
                int n5 = 0;
                while (n5 < n4) {
                    String[] name2 = stringArray2[n5];
                    this.trueTypeFonts.put(name2[3].toLowerCase(), path);
                    ++n5;
                }
                String fullName = null;
                String familyName = null;
                names = (String[][])allNames[1];
                int k2 = 0;
                while (k2 < TTFamilyOrder.length) {
                    stringArray = names;
                    n3 = names.length;
                    n2 = 0;
                    while (n2 < n3) {
                        name = stringArray[n2];
                        if (TTFamilyOrder[k2].equals(name[0]) && TTFamilyOrder[k2 + 1].equals(name[1]) && TTFamilyOrder[k2 + 2].equals(name[2])) {
                            familyName = name[3].toLowerCase();
                            k2 = TTFamilyOrder.length;
                            break;
                        }
                        ++n2;
                    }
                    k2 += 3;
                }
                if (familyName != null) {
                    String lastName = "";
                    stringArray = names = (String[][])allNames[2];
                    n3 = names.length;
                    n2 = 0;
                    while (n2 < n3) {
                        name = stringArray[n2];
                        int k3 = 0;
                        while (k3 < TTFamilyOrder.length) {
                            if (TTFamilyOrder[k3].equals(name[0]) && TTFamilyOrder[k3 + 1].equals(name[1]) && TTFamilyOrder[k3 + 2].equals(name[2]) && !(fullName = name[3]).equals(lastName)) {
                                lastName = fullName;
                                this.registerFamily(familyName, fullName, null);
                                break;
                            }
                            k3 += 3;
                        }
                        ++n2;
                    }
                }
            } else if (path.toLowerCase().endsWith(".ttc")) {
                if (alias != null) {
                    System.err.println("class FontFactory: You can't define an alias for a true type collection.");
                }
                String[] names = BaseFont.enumerateTTCNames(path);
                int i2 = 0;
                while (i2 < names.length) {
                    this.register(String.valueOf(path) + "," + i2);
                    ++i2;
                }
            } else if (path.toLowerCase().endsWith(".afm") || path.toLowerCase().endsWith(".pfm")) {
                BaseFont bf = BaseFont.createFont(path, "Cp1252", false);
                String fullName = bf.getFullFontName()[0][3].toLowerCase();
                String familyName = bf.getFamilyFontName()[0][3].toLowerCase();
                String psName = bf.getPostscriptFontName().toLowerCase();
                this.registerFamily(familyName, fullName, null);
                this.trueTypeFonts.put(psName, path);
                this.trueTypeFonts.put(fullName, path);
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    public int registerDirectory(String dir2) {
        return this.registerDirectory(dir2, false);
    }

    public int registerDirectory(String dir2, boolean scanSubdirectories) {
        String[] files;
        File file;
        int count;
        block15: {
            block14: {
                count = 0;
                file = new File(dir2);
                if (file.exists() && file.isDirectory()) break block14;
                return 0;
            }
            files = file.list();
            if (files != null) break block15;
            return 0;
        }
        try {
            int k2 = 0;
            while (k2 < files.length) {
                try {
                    file = new File(dir2, files[k2]);
                    if (file.isDirectory()) {
                        if (scanSubdirectories) {
                            count += this.registerDirectory(file.getAbsolutePath(), true);
                        }
                    } else {
                        String suffix;
                        String name = file.getPath();
                        String string = suffix = name.length() < 4 ? null : name.substring(name.length() - 4).toLowerCase();
                        if (".afm".equals(suffix) || ".pfm".equals(suffix)) {
                            File pfb = new File(String.valueOf(name.substring(0, name.length() - 4)) + ".pfb");
                            if (pfb.exists()) {
                                this.register(name, null);
                                ++count;
                            }
                        } else if (".ttf".equals(suffix) || ".otf".equals(suffix) || ".ttc".equals(suffix)) {
                            this.register(name, null);
                            ++count;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++k2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public int registerDirectories() {
        int count = 0;
        count += this.registerDirectory("c:/windows/fonts");
        count += this.registerDirectory("c:/winnt/fonts");
        count += this.registerDirectory("d:/windows/fonts");
        count += this.registerDirectory("d:/winnt/fonts");
        count += this.registerDirectory("/usr/share/X11/fonts", true);
        count += this.registerDirectory("/usr/X/lib/X11/fonts", true);
        count += this.registerDirectory("/usr/openwin/lib/X11/fonts", true);
        count += this.registerDirectory("/usr/share/fonts", true);
        count += this.registerDirectory("/usr/X11R6/lib/X11/fonts", true);
        count += this.registerDirectory("/Library/Fonts");
        return count += this.registerDirectory("/System/Library/Fonts");
    }

    public Set<String> getRegisteredFonts() {
        return this.trueTypeFonts.keySet();
    }

    public Set<String> getRegisteredFamilies() {
        return this.fontFamilies.keySet();
    }

    @Override
    public boolean isRegistered(String fontname) {
        return this.trueTypeFonts.containsKey(fontname.toLowerCase());
    }
}

