/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class X509Key
implements PublicKey {
    private static final long serialVersionUID = -5359250853002055002L;
    protected AlgorithmId algid;
    protected byte[] key = null;
    private int unusedBits = 0;
    private BitArray bitStringKey = null;
    protected byte[] encodedKey;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X509Key";

    public X509Key() {
        if (debug != null) {
            debug.entry(16384L, className, "X509Key");
            debug.exit(16384L, className, "X509Key");
        }
    }

    private X509Key(AlgorithmId algid, BitArray key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, className, "X509Key", algid, key);
        }
        this.algid = algid;
        this.setKey(key);
        this.encode();
        if (debug != null) {
            debug.exit(16384L, className, "X509Key");
        }
    }

    protected void setKey(BitArray key) {
        this.bitStringKey = (BitArray)key.clone();
        this.key = key.toByteArray();
        int remaining = key.length() % 8;
        this.unusedBits = remaining == 0 ? 0 : 8 - remaining;
    }

    protected BitArray getKey() {
        this.bitStringKey = new BitArray(this.key.length * 8 - this.unusedBits, this.key);
        return (BitArray)this.bitStringKey.clone();
    }

    public static PublicKey parse(DerValue in, String provider) throws IOException {
        PublicKey subjectKey;
        if (debug != null) {
            debug.entry(16384L, className, "parse", in, provider);
        }
        if (in.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "corrupt subject key");
            }
            throw new IOException("corrupt subject key");
        }
        AlgorithmId algorithm = AlgorithmId.parse(in.getData().getDerValue());
        try {
            subjectKey = X509Key.buildX509Key(algorithm, in.getData().getUnalignedBitString(), provider);
        }
        catch (InvalidKeyException e2) {
            if (debug != null) {
                debug.exception(512L, className, "parse", e2);
            }
            throw new IOException("subject key, " + e2.getMessage());
        }
        if (in.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "excess subject key");
            }
            throw new IOException("excess subject key");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "parse", subjectKey);
        }
        return subjectKey;
    }

    public static PublicKey parse(DerValue in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "parse", in);
            debug.exit(16384L, className, "parse");
        }
        return X509Key.parse(in, null);
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, className, "parseKeyBits");
        }
        this.encode();
        if (debug != null) {
            debug.exit(16384L, className, "parseKeyBits");
        }
    }

    static PublicKey buildX509Key(AlgorithmId algid, BitArray key, String provider) throws IOException, InvalidKeyException {
        PublicKey value = null;
        if (debug != null) {
            Object[] parms = new Object[]{algid, key, provider};
            debug.entry(16384L, (Object)className, "buildX509Key", parms);
        }
        DerOutputStream x509EncodedKeyStream = new DerOutputStream();
        X509Key.encode(x509EncodedKeyStream, algid, key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(x509EncodedKeyStream.toByteArray());
        try {
            KeyFactory keyFac = null;
            if (provider != null) {
                try {
                    keyFac = KeyFactory.getInstance(algid.getName(), provider);
                }
                catch (NoSuchAlgorithmException ae) {
                    keyFac = KeyFactory.getInstance(algid.getName());
                }
            } else {
                keyFac = KeyFactory.getInstance(algid.getName());
            }
            value = keyFac.generatePublic(x509KeySpec);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "buildX509Key", value);
            }
            return value;
        }
        catch (NoSuchProviderException e2) {
            if (debug != null) {
                debug.exception(512L, className, "buildX509Key", e2);
            }
        }
        catch (NoSuchAlgorithmException e3) {
            if (debug != null) {
                debug.exception(512L, className, "buildX509Key", e3);
            }
        }
        catch (InvalidKeySpecException e4) {
            if (debug != null) {
                debug.exception(512L, className, "buildX509Key", e4);
            }
            throw new InvalidKeyException(e4.toString());
        }
        X509Key result = new X509Key();
        result.algid = algid;
        result.setKey(key);
        result.parseKeyBits();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "buildX509Key", result);
        }
        return result;
    }

    static PublicKey buildX509Key(AlgorithmId algid, byte[] key, String provider) throws IOException, InvalidKeyException {
        PublicKey value = null;
        if (debug != null) {
            Object[] parms = new Object[]{algid, key, provider};
            debug.entry(16384L, (Object)className, "buildX509Key", parms);
        }
        DerOutputStream x509EncodedKeyStream = new DerOutputStream();
        X509Key.encode(x509EncodedKeyStream, algid, key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(x509EncodedKeyStream.toByteArray());
        try {
            KeyFactory keyFac = null;
            keyFac = provider != null ? KeyFactory.getInstance(algid.getName(), provider) : KeyFactory.getInstance(algid.getName());
            value = keyFac.generatePublic(x509KeySpec);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "buildX509Key", value);
            }
            return value;
        }
        catch (NoSuchProviderException e2) {
            if (debug != null) {
                debug.exception(512L, className, "buildX509Key", e2);
            }
        }
        catch (NoSuchAlgorithmException e3) {
            if (debug != null) {
                debug.exception(512L, className, "buildX509Key", e3);
            }
        }
        catch (InvalidKeySpecException e4) {
            if (debug != null) {
                debug.exception(512L, className, "buildX509Key", e4);
            }
            throw new InvalidKeyException(e4.toString());
        }
        X509Key result = new X509Key();
        result.algid = algid;
        result.setKey(new BitArray(key.length, key));
        result.parseKeyBits();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "buildX509Key", result);
        }
        return result;
    }

    @Override
    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgorithm");
            debug.exit(16384L, (Object)className, "getAlgorithm", this.algid.getName());
        }
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgorithmId");
            debug.exit(16384L, (Object)className, "getAlgorithmId", this.algid);
        }
        return this.algid;
    }

    public final void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        X509Key.encode(out, this.algid, this.getKey());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public synchronized byte[] getEncoded() {
        byte[] result;
        block4: {
            if (debug != null) {
                debug.entry(16384L, className, "getEncoded");
            }
            result = null;
            try {
                result = (byte[])this.getEncodedInternal().clone();
            }
            catch (InvalidKeyException e2) {
                if (debug == null) break block4;
                debug.exception(512L, className, "getEncoded", e2);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncoded", result);
        }
        return result;
    }

    private byte[] getEncodedInternal() throws InvalidKeyException {
        byte[] encoded = this.encodedKey;
        if (encoded == null) {
            try {
                DerOutputStream out = new DerOutputStream();
                this.encode(out);
                encoded = out.toByteArray();
            }
            catch (IOException e2) {
                throw new InvalidKeyException("IOException : " + e2.getMessage());
            }
            this.encodedKey = encoded;
        }
        return encoded;
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.entry(16384L, className, "getFormat");
            debug.exit(16384L, (Object)className, "getFormat", "X.509");
        }
        return "X.509";
    }

    public byte[] encode() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, className, "encode");
        }
        byte[] result = (byte[])this.getEncodedInternal().clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encode", result);
        }
        return result;
    }

    public String toString() {
        HexDumpEncoder encoder = new HexDumpEncoder();
        return "algorithm = " + this.algid.toString() + ", unparsed keybits = \r\n" + encoder.encodeBuffer(this.key);
    }

    public void decode(InputStream in) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
        }
        try {
            DerValue val = new DerValue(in);
            if (val.getTag() != 48) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "invalid key format");
                }
                throw new InvalidKeyException("invalid key format");
            }
            this.algid = AlgorithmId.parse(val.getData().getDerValue());
            this.setKey(val.getData().getUnalignedBitString());
            this.parseKeyBits();
            if (val.getData().available() != 0) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "excess key data");
                }
                throw new InvalidKeyException("excess key data");
            }
        }
        catch (IOException e2) {
            if (debug != null) {
                e2.printStackTrace();
                debug.exception(512L, className, "decode", e2);
            }
            throw new InvalidKeyException("IOException: " + e2.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public void decode(byte[] encodedKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", (Object)encodedKey);
        }
        this.decode(new ByteArrayInputStream(encodedKey));
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "writeObject", stream);
        }
        stream.write(this.getEncoded());
        if (debug != null) {
            debug.exit(16384L, className, "writeObject");
        }
    }

    private synchronized void readObject(ObjectInputStream stream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "readObject", stream);
        }
        try {
            this.decode(stream);
        }
        catch (InvalidKeyException e2) {
            if (debug != null) {
                debug.exception(512L, className, "readObject", e2);
            }
            throw new IOException("deserialized key is invalid: " + e2.getMessage());
        }
        if (debug != null) {
            debug.exit(8192L, className, "readObject");
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", object);
        }
        if (this == object) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof Key)) {
            return false;
        }
        try {
            byte[] thisEncoded = this.getEncodedInternal();
            byte[] otherEncoded = object instanceof X509Key ? ((X509Key)object).getEncodedInternal() : ((Key)object).getEncoded();
            boolean result = Arrays.equals(thisEncoded, otherEncoded);
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(result));
            }
            return result;
        }
        catch (InvalidKeyException e2) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
    }

    public int hashCode() {
        int retval = 0;
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        byte[] b1 = this.getEncoded();
        for (int i2 = 1; i2 < b1.length; ++i2) {
            retval += b1[i2] * i2;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hashCode", retval);
        }
        return retval;
    }

    static void encode(DerOutputStream out, AlgorithmId algid, byte[] key) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{out, algid, key};
            debug.entry(16384L, (Object)className, "encode", parms);
        }
        DerOutputStream tmp = new DerOutputStream();
        algid.encode(tmp);
        tmp.putBitString(key);
        out.write((byte)48, tmp);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    static void encode(DerOutputStream out, AlgorithmId algid, BitArray key) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{out, algid, key};
            debug.entry(16384L, (Object)className, "encode", parms);
        }
        DerOutputStream tmp = new DerOutputStream();
        algid.encode(tmp);
        tmp.putUnalignedBitString(key);
        out.write((byte)48, tmp);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void write(String filename) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "write", filename);
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            byte[] encoding = this.encode();
            fos.write(encoding);
            fos.close();
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(512L, className, "write", e2);
            }
            throw new IOException("Could not write to " + filename + ".  " + e2.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "write");
        }
    }

    public void writeBASE64(String filename) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "writeBASE64", filename);
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            byte[] encoding = this.encode();
            BASE64Encoder encoder = new BASE64Encoder();
            encoder.encode(encoding, (OutputStream)fos);
            fos.close();
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(512L, className, "writeBASE64", e2);
            }
            throw new IOException("Could not write to " + filename + ".  " + e2.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "writeBASE64");
        }
    }

    protected void read(String filename) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "read", filename);
        }
        try {
            FileInputStream fis;
            try {
                fis = new FileInputStream(filename);
            }
            catch (FileNotFoundException e2) {
                if (debug != null) {
                    debug.exception(512L, className, "read", e2);
                }
                throw new IOException("File " + filename + " not found.");
            }
            int numBytes = fis.available();
            byte[] encoding = new byte[numBytes];
            fis.read(encoding);
            fis.close();
            this.decode(encoding);
        }
        catch (Exception e3) {
            if (debug != null) {
                debug.exception(512L, className, "read", e3);
            }
            throw new IOException("Could not read from " + filename + ".  " + e3.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "read");
        }
    }

    protected void readBASE64(String filename) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "readBASE64", filename);
        }
        try {
            FileInputStream fis;
            try {
                fis = new FileInputStream(filename);
            }
            catch (FileNotFoundException e2) {
                if (debug != null) {
                    debug.exception(512L, className, "readBASE64", e2);
                }
                throw new IOException("File " + filename + " not found.");
            }
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] encoding = decoder.decodeBuffer(fis);
            fis.close();
            this.decode(encoding);
        }
        catch (Exception e3) {
            if (debug != null) {
                debug.exception(512L, className, "readBASE64", e3);
            }
            throw new IOException("Could not read from " + filename + ".  " + e3.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "readBASE64");
        }
    }
}

