/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.util.text.Normalizer;
import com.ibm.security.x509.AVAKeyword;
import com.ibm.security.x509.X500Name;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class AVA
implements DerEncoder {
    static final int DEFAULT = 1;
    static final int RFC1779 = 2;
    static final int RFC2253 = 3;
    private static final String specialChars = ",+=\n<>#;";
    private static final String specialChars2253 = ",+\"\\<>;";
    private static final String specialCharsAll = ",=\n+<>#;\\\" ";
    private static final String hexDigits = "0123456789ABCDEF";
    private static final String digits = "0123456789ABCDEF";
    final ObjectIdentifier oid;
    final DerValue value;
    private String valueString;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.AVA";

    public AVA(ObjectIdentifier type, DerValue val) {
        if (debug != null) {
            debug.entry(16384L, className, "AVA", type, val);
        }
        if (type == null || val == null) {
            throw new NullPointerException();
        }
        this.oid = type;
        this.value = val;
        if (debug != null) {
            debug.text(16384L, className, "AVA", "AVA() oid = " + this.oid);
            debug.text(16384L, className, "AVA", "AVA() value = " + this.value);
            debug.exit(16384L, className, "AVA");
        }
    }

    AVA(Reader in) throws IOException {
        this(in, 1);
    }

    AVA(Reader in, Map<String, String> keywordMap) throws IOException {
        this(in, 1, keywordMap);
    }

    AVA(Reader in, int format) throws IOException {
        this(in, format, Collections.EMPTY_MAP);
    }

    AVA(Reader in, int format, Map<String, String> keywordMap) throws IOException {
        int c2;
        if (debug != null) {
            debug.entry(16384L, className, "AVA", in, new Integer(format));
        }
        StringBuilder temp = new StringBuilder();
        while ((c2 = AVA.readChar(in, "Incorrect AVA format")) != 61) {
            temp.append((char)c2);
        }
        this.oid = AVAKeyword.getOID(temp.toString(), format, keywordMap);
        temp.setLength(0);
        if (format == 3) {
            c2 = in.read();
            if (c2 == 32) {
                throw new IOException("Incorrect AVA RFC2253 format - leading space must be escaped");
            }
        } else {
            while ((c2 = in.read()) == 32 || c2 == 10) {
            }
        }
        if (c2 == -1) {
            this.value = this.oid.equals(X500Name.emailAddress_oid) || this.oid.equals(X500Name.domainComponent_oid) ? new DerValue(22, "") : new DerValue("");
            return;
        }
        this.value = c2 == 35 ? AVA.parseHexString(in, format) : (c2 == 34 && format != 3 ? this.parseQuotedString(in, temp) : this.parseString(in, c2, format, temp));
    }

    public AVA(String ava) throws IOException {
        this(new StringReader(ava));
    }

    AVA(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AVA", in);
        }
        StringBuilder temp = new StringBuilder();
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parseInputStream", in);
        }
        while (true) {
            int byteRead;
            if ((byteRead = in.read()) == -1) {
                if (debug != null) {
                    debug.text(8192L, className, "parseInputStream", "Incorrect AVA format");
                }
                throw new IOException("Incorrect AVA format");
            }
            if ((char)byteRead == '=') break;
            temp.append((char)byteRead);
        }
        String keyword = temp.toString().toUpperCase(Locale.US).trim();
        int dertype = 19;
        if (keyword.equals("CN")) {
            this.oid = X500Name.commonName_oid;
        } else if (keyword.equals("C")) {
            this.oid = X500Name.countryName_oid;
        } else if (keyword.equals("L")) {
            this.oid = X500Name.localityName_oid;
        } else if (keyword.equals("S") || keyword.equals("ST")) {
            this.oid = X500Name.stateName_oid;
        } else if (keyword.equals("O")) {
            this.oid = X500Name.orgName_oid;
        } else if (keyword.equals("OU")) {
            this.oid = X500Name.orgUnitName_oid;
        } else if (keyword.equals("T") || keyword.equals("TITLE")) {
            this.oid = X500Name.title_oid;
        } else if (keyword.equals("IP")) {
            this.oid = X500Name.ipAddress_oid;
        } else if (keyword.equals("STREET")) {
            this.oid = X500Name.streetAddress_oid;
        } else if (keyword.equals("EMAIL") || keyword.equals("EMAILADDRESS")) {
            this.oid = X500Name.emailAddress_oid;
            dertype = 22;
        } else if (keyword.equals("SERIALNUMBER")) {
            this.oid = X500Name.serialNumber_oid;
        } else if (keyword.equals("DC")) {
            this.oid = X500Name.domainComponent_oid;
            dertype = 22;
        } else if (keyword.startsWith("OID.")) {
            this.oid = new ObjectIdentifier(keyword.substring(4));
        } else if (keyword.equals("POSTALCODE")) {
            this.oid = X500Name.postalCode_oid;
        } else if (keyword.equals("DNQ") || keyword.equals("DNQUALIFIER")) {
            this.oid = X500Name.dnQualifier_oid;
        } else if (keyword.equals("PSEUDONYM")) {
            this.oid = X500Name.pseudonym_oid;
        } else if (keyword.equals("SURNAME") || keyword.equals("SN")) {
            this.oid = X500Name.surName_oid;
        } else if (keyword.equals("GIVENNAME")) {
            this.oid = X500Name.givenName_oid;
        } else if (keyword.equals("INITIALS")) {
            this.oid = X500Name.initials_oid;
        } else if (keyword.equals("GENERATION") || keyword.equals("GENERATIONQUALIFIER")) {
            this.oid = X500Name.generationQualifier_oid;
        } else if (keyword.equals("UID")) {
            this.oid = X500Name.userid_oid;
        } else {
            if (debug != null) {
                debug.text(8192L, className, "parseInputStream", "unsupported keyword " + keyword);
            }
            throw new IOException("unsupported keyword " + keyword);
        }
        temp = new StringBuilder();
        char c2 = (char)in.read();
        while (c2 == ' ' || c2 == '\n') {
            c2 = (char)in.read();
        }
        if (c2 == '\uffffffff') {
            if (debug != null) {
                debug.text(8192L, className, "parseInputStream", "Incorrect AVA format");
            }
            throw new IOException("Incorrect AVA format");
        }
        if (c2 == '#') {
            if (debug != null) {
                debug.text(8192L, className, "parseInputStream", "AVA parse, hex values!");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int b2 = 0;
            int cNdx = 0;
            while (!AVA.isTerminator((short)(c2 = (char)in.read()), 1)) {
                int cVal = "0123456789ABCDEF".indexOf(Character.toUpperCase(c2));
                if (cVal == -1) {
                    throw new IOException("AVA parse, invalid hex digit: " + c2);
                }
                if (cNdx % 2 == 1) {
                    b2 = (byte)(b2 * 16 + (byte)cVal);
                    baos.write(b2);
                } else {
                    b2 = (byte)cVal;
                }
                ++cNdx;
            }
            if (cNdx == 0) {
                throw new IOException("AVA parse, zero hex digits");
            }
            if (cNdx % 2 == 1) {
                throw new IOException("AVA parse, odd number of hex digits");
            }
            byte[] byteArray = baos.toByteArray();
            this.value = new DerValue(byteArray);
        } else if (c2 == '\"') {
            int r2 = in.read();
            c2 = (char)r2;
            while (r2 != -1 && c2 != '\"') {
                if (c2 == '\\') {
                    c2 = (char)in.read();
                }
                temp.append(c2);
                r2 = in.read();
                c2 = (char)r2;
            }
            this.value = new DerValue((byte)dertype, temp.toString().trim());
        } else {
            int r3;
            do {
                if (c2 == '\\') {
                    c2 = (char)in.read();
                }
                temp.append(c2);
                r3 = in.read();
                c2 = (char)r3;
            } while (r3 != -1 && c2 != '+' && c2 != ',' && c2 != ';' && c2 != '>');
            this.value = new DerValue((byte)dertype, temp.toString().trim());
        }
        if (debug != null) {
            debug.exit(8192L, className, "parseInputStream");
        }
    }

    private static boolean isTerminator(int ch, int format) {
        switch (ch) {
            case -1: 
            case 43: 
            case 44: {
                return true;
            }
            case 59: 
            case 62: {
                return format != 3;
            }
        }
        return false;
    }

    public AVA(DerInputStream in) throws IOException {
        DerValue assertion;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AVA", in);
        }
        if ((assertion = in.getDerValue()).getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AVA", "X500 AVA, not a sequence");
            }
            throw new IOException("X500 AVA, not a sequence");
        }
        this.oid = X500Name.intern(assertion.getData().getOID());
        this.value = assertion.getData().getDerValue();
        if (assertion.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "AVA", "AVA, extra bytes = " + assertion.getData().available());
            }
            throw new IOException("AVA, extra bytes = " + assertion.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "AVA");
        }
    }

    ObjectIdentifier getObjectIdentifier() {
        return this.oid;
    }

    String getValueString() {
        try {
            String s2 = this.value.getAsString();
            if (s2 == null) {
                throw new RuntimeException("AVA string is null");
            }
            return s2;
        }
        catch (IOException e2) {
            throw new RuntimeException("AVA error: " + e2, e2);
        }
    }

    private static DerValue parseHexString(Reader in, int format) throws IOException {
        int c2;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b2 = 0;
        int cNdx = 0;
        while (!AVA.isTerminator(c2 = in.read(), format)) {
            int cVal = "0123456789ABCDEF".indexOf(Character.toUpperCase((char)c2));
            if (cVal == -1) {
                throw new IOException("AVA parse, invalid hex digit: " + (char)c2);
            }
            if (cNdx % 2 == 1) {
                b2 = (byte)(b2 * 16 + (byte)cVal);
                baos.write(b2);
            } else {
                b2 = (byte)cVal;
            }
            ++cNdx;
        }
        if (cNdx == 0) {
            throw new IOException("AVA parse, zero hex digits");
        }
        if (cNdx % 2 == 1) {
            throw new IOException("AVA parse, odd number of hex digits");
        }
        return new DerValue(baos.toByteArray());
    }

    private DerValue parseQuotedString(Reader in, StringBuilder temp) throws IOException {
        String hexString;
        int c2 = AVA.readChar(in, "Quoted string did not end in quote");
        ArrayList<Byte> embeddedHex = new ArrayList<Byte>();
        boolean isPrintableString = true;
        while (c2 != 34) {
            if (c2 == 92) {
                c2 = AVA.readChar(in, "Quoted string did not end in quote");
                Byte hexByte = null;
                hexByte = AVA.getEmbeddedHexPair(c2, in);
                if (hexByte != null) {
                    isPrintableString = false;
                    embeddedHex.add(hexByte);
                    c2 = in.read();
                    continue;
                }
                if (c2 != 92 && c2 != 34 && specialChars.indexOf((char)c2) < 0) {
                    throw new IOException("Invalid escaped character in AVA: " + (char)c2);
                }
            }
            if (embeddedHex.size() > 0) {
                hexString = AVA.getEmbeddedHexString(embeddedHex);
                temp.append(hexString);
                embeddedHex.clear();
            }
            isPrintableString &= DerValue.isPrintableStringChar((char)c2);
            temp.append((char)c2);
            c2 = AVA.readChar(in, "Quoted string did not end in quote");
        }
        if (embeddedHex.size() > 0) {
            hexString = AVA.getEmbeddedHexString(embeddedHex);
            temp.append(hexString);
            embeddedHex.clear();
        }
        while ((c2 = in.read()) == 10 || c2 == 32) {
        }
        if (c2 != -1) {
            throw new IOException("AVA had characters other than whitespace after terminating quote");
        }
        if (this.oid.equals(X500Name.emailAddress_oid) || this.oid.equals(X500Name.domainComponent_oid)) {
            return new DerValue(22, temp.toString().toLowerCase().trim());
        }
        if (isPrintableString) {
            return new DerValue(temp.toString().trim());
        }
        return new DerValue(12, temp.toString().trim());
    }

    private DerValue parseString(Reader in, int c2, int format, StringBuilder temp) throws IOException {
        ArrayList<Byte> embeddedHex = new ArrayList<Byte>();
        boolean isPrintableString = true;
        boolean escape = false;
        boolean leadingChar = true;
        int spaceCount = 0;
        do {
            escape = false;
            if (c2 == 92) {
                escape = true;
                c2 = AVA.readChar(in, "Invalid trailing backslash");
                Byte hexByte = null;
                hexByte = AVA.getEmbeddedHexPair(c2, in);
                if (hexByte != null) {
                    isPrintableString = false;
                    embeddedHex.add(hexByte);
                    c2 = in.read();
                    leadingChar = false;
                    continue;
                }
                if (format == 1 && specialCharsAll.indexOf((char)c2) == -1 || format == 2 && specialChars.indexOf((char)c2) == -1 && c2 != 92 && c2 != 34) {
                    throw new IOException("Invalid escaped character in AVA: '" + (char)c2 + "'");
                }
                if (format == 3) {
                    if (c2 == 32) {
                        if (!leadingChar && !AVA.trailingSpace(in)) {
                            throw new IOException("Invalid escaped space character in AVA.  Only a leading or trailing space character can be escaped.");
                        }
                    } else if (c2 == 35) {
                        if (!leadingChar) {
                            throw new IOException("Invalid escaped '#' character in AVA.  Only a leading '#' can be escaped.");
                        }
                    } else if (specialChars2253.indexOf((char)c2) == -1) {
                        throw new IOException("Invalid escaped character in AVA: '" + (char)c2 + "'");
                    }
                }
            } else if (format == 3 && specialChars2253.indexOf((char)c2) != -1) {
                throw new IOException("Character '" + (char)c2 + "' in AVA appears without escape");
            }
            if (embeddedHex.size() > 0) {
                for (int i2 = 0; i2 < spaceCount; ++i2) {
                    temp.append(" ");
                }
                spaceCount = 0;
                String hexString = AVA.getEmbeddedHexString(embeddedHex);
                temp.append(hexString);
                embeddedHex.clear();
            }
            isPrintableString &= DerValue.isPrintableStringChar((char)c2);
            if (c2 == 32 && !escape) {
                ++spaceCount;
            } else {
                for (int i3 = 0; i3 < spaceCount; ++i3) {
                    temp.append(" ");
                }
                spaceCount = 0;
                temp.append((char)c2);
            }
            c2 = in.read();
            leadingChar = false;
        } while (!AVA.isTerminator(c2, format));
        if (format == 3 && spaceCount > 0) {
            throw new IOException("Incorrect AVA RFC2253 format - trailing space must be escaped");
        }
        if (embeddedHex.size() > 0) {
            String hexString = AVA.getEmbeddedHexString(embeddedHex);
            temp.append(hexString);
            embeddedHex.clear();
        }
        if (this.oid.equals(X500Name.emailAddress_oid) || this.oid.equals(X500Name.domainComponent_oid)) {
            return new DerValue(22, temp.toString().toLowerCase());
        }
        if (isPrintableString) {
            return new DerValue(temp.toString());
        }
        return new DerValue(12, temp.toString());
    }

    private static Byte getEmbeddedHexPair(int c1, Reader in) throws IOException {
        if ("0123456789ABCDEF".indexOf(Character.toUpperCase((char)c1)) >= 0) {
            int c2 = AVA.readChar(in, "unexpected EOF - escaped hex value must include two valid digits");
            if ("0123456789ABCDEF".indexOf(Character.toUpperCase((char)c2)) >= 0) {
                int hi = Character.digit((char)c1, 16);
                int lo = Character.digit((char)c2, 16);
                return new Byte((byte)((hi << 4) + lo));
            }
            throw new IOException("escaped hex value must include two valid digits");
        }
        return null;
    }

    private static String getEmbeddedHexString(List<Byte> hexList) throws IOException {
        byte[] hexBytes = new byte[hexList.size()];
        for (int i2 = 0; i2 < hexList.size(); ++i2) {
            hexBytes[i2] = hexList.get(i2);
        }
        return new String(hexBytes, "UTF8");
    }

    private static boolean trailingSpace(Reader in) throws IOException {
        boolean trailing;
        block3: {
            block4: {
                trailing = false;
                if (!in.markSupported()) {
                    return true;
                }
                in.mark(9999);
                while (true) {
                    int nextChar;
                    if ((nextChar = in.read()) == -1) {
                        trailing = true;
                        break block3;
                    }
                    if (nextChar == 32) continue;
                    if (nextChar != 92) break block4;
                    int followingChar = in.read();
                    if (followingChar != 32) break;
                }
                trailing = false;
                break block3;
            }
            trailing = false;
        }
        in.reset();
        return trailing;
    }

    private static int readChar(Reader in, String errMsg) throws IOException {
        int c2 = in.read();
        if (c2 == -1) {
            throw new IOException(errMsg);
        }
        return c2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AVA)) {
            return false;
        }
        AVA obj = (AVA)other;
        return this.toRFC2253CanonicalString().equals(obj.toRFC2253CanonicalString());
    }

    public int hashCode() {
        return this.toRFC2253CanonicalString().hashCode();
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        this.derEncode(out);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        DerOutputStream tmp2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", out);
        }
        tmp.putOID(this.oid);
        this.value.encode(tmp);
        tmp2.write((byte)48, tmp);
        out.write(tmp2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    private String toKeyword(int format, Map<String, String> oidMap) {
        return AVAKeyword.getKeyword(this.oid, format, oidMap);
    }

    private static boolean isDerString(DerValue value, boolean canonical) {
        if (canonical) {
            switch (value.getTag()) {
                case 12: 
                case 19: 
                case 20: 
                case 22: {
                    return true;
                }
            }
            return false;
        }
        switch (value.getTag()) {
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    boolean hasRFC2253Keyword() {
        return AVAKeyword.hasKeyword(this.oid, 3);
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String keyword = this.toKeywordValueString(this.toKeyword(1, Collections.EMPTY_MAP));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", keyword);
        }
        return keyword;
    }

    public String getName() {
        String retval = null;
        if (debug != null) {
            debug.entry(16384L, className, "getName");
        }
        retval = this.oid.equals(X500Name.commonName_oid) ? "CN" : (this.oid.equals(X500Name.countryName_oid) ? "C" : (this.oid.equals(X500Name.localityName_oid) ? "L" : (this.oid.equals(X500Name.stateName_oid) ? "ST" : (this.oid.equals(X500Name.orgName_oid) ? "O" : (this.oid.equals(X500Name.orgUnitName_oid) ? "OU" : (this.oid.equals(X500Name.title_oid) ? "T" : (this.oid.equals(X500Name.ipAddress_oid) ? "IP" : (this.oid.equals(X500Name.streetAddress_oid) ? "STREET" : (this.oid.equals(X500Name.domainComponent_oid) ? "DC" : (this.oid.equals(X500Name.dnQualifier_oid) ? "DNQ" : (this.oid.equals(X500Name.pseudonym_oid) ? "PSEUDONYM" : (this.oid.equals(X500Name.surName_oid) ? "SURNAME" : (this.oid.equals(X500Name.givenName_oid) ? "GIVENNAME" : (this.oid.equals(X500Name.initials_oid) ? "INITIALS" : (this.oid.equals(X500Name.generationQualifier_oid) ? "GENERATION" : (this.oid.equals(X500Name.emailAddress_oid) ? "EMAILADDRESS" : (this.oid.equals(X500Name.userid_oid) ? "UID" : (this.oid.equals(X500Name.serialNumber_oid) ? "SERIALNUMBER" : (this.oid.equals(X500Name.postalCode_oid) ? "POSTALCODE" : "OID." + this.oid.toString())))))))))))))))))));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getName", retval);
        }
        return retval;
    }

    public String toRFC1779String() {
        return this.toRFC1779String(Collections.EMPTY_MAP);
    }

    public String toRFC1779String(Map<String, String> oidMap) {
        return this.toKeywordValueString(this.toKeyword(2, oidMap));
    }

    public String toRFC2253String() {
        return this.toRFC2253String(Collections.EMPTY_MAP);
    }

    public String toRFC2253String(Map<String, String> oidMap) {
        StringBuilder typeAndValue = new StringBuilder(100);
        typeAndValue.append(this.toKeyword(3, oidMap));
        typeAndValue.append('=');
        if (typeAndValue.charAt(0) >= '0' && typeAndValue.charAt(0) <= '9' || !AVA.isDerString(this.value, false)) {
            byte[] data = null;
            try {
                data = this.value.toByteArray();
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            typeAndValue.append('#');
            for (int j2 = 0; j2 < data.length; ++j2) {
                byte b2 = data[j2];
                typeAndValue.append(Character.forDigit(0xF & b2 >>> 4, 16));
                typeAndValue.append(Character.forDigit(0xF & b2, 16));
            }
        } else {
            int trail;
            int lead;
            String valStr = null;
            try {
                valStr = this.getValueStr();
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            String escapees = ",=+<>#;\"\\";
            char[] chars = valStr.toCharArray();
            StringBuilder buf = new StringBuilder(2 * valStr.length());
            for (lead = 0; lead < chars.length && (chars[lead] == ' ' || chars[lead] == '\r'); ++lead) {
            }
            for (trail = chars.length - 1; trail >= 0 && (chars[trail] == ' ' || chars[trail] == '\r'); --trail) {
            }
            for (int i2 = 0; i2 < chars.length; ++i2) {
                char c2 = chars[i2];
                if (i2 >= lead || i2 <= trail) {
                    if (",=+<>#;\"\\".indexOf(c2) >= 0) {
                        buf.append('\\');
                        buf.append(c2);
                        continue;
                    }
                    if (c2 == '\u0000') {
                        buf.append("\\00");
                        continue;
                    }
                    buf.append(c2);
                    continue;
                }
                buf.append(c2);
            }
            typeAndValue.append(buf.toString());
        }
        return typeAndValue.toString();
    }

    public String toRFC2253CanonicalString() {
        StringBuilder typeAndValue = new StringBuilder(40);
        typeAndValue.append(this.toKeyword(3, Collections.EMPTY_MAP));
        typeAndValue.append('=');
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2253CanonicalString", this.toKeyword(3, Collections.EMPTY_MAP));
        }
        if (typeAndValue.charAt(0) >= '0' && typeAndValue.charAt(0) <= '9' || !AVA.isDerString(this.value, true)) {
            byte[] data = null;
            try {
                data = this.value.toByteArray();
                if (debug != null) {
                    debug.entry(16384L, (Object)className, "toRFC2253CanonicalString:digit", (Object)data);
                }
            }
            catch (IOException ie) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "toRFC2253CanonicalString_1", "DER Value conversion");
                }
                throw new IllegalArgumentException("DER Value conversion");
            }
            typeAndValue.append('#');
            for (int j2 = 0; j2 < data.length; ++j2) {
                byte b2 = data[j2];
                typeAndValue.append(Character.forDigit(0xF & b2 >>> 4, 16));
                typeAndValue.append(Character.forDigit(0xF & b2, 16));
            }
        } else {
            int trail;
            String valStr = null;
            try {
                valStr = this.getValueStr();
            }
            catch (IOException ie) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "toRFC2253CanonicalString_2", "DER Value conversion");
                }
                throw new IllegalArgumentException("DER Value conversion");
            }
            String escapees = ",=<>;\"\\";
            char[] chars = valStr.toCharArray();
            StringBuilder buf = new StringBuilder(2 * valStr.length());
            if (chars.length > 0 && chars[0] == '#') {
                buf.append('\\');
            }
            for (int lead = 0; lead < chars.length && Character.isWhitespace(chars[lead]); ++lead) {
            }
            for (trail = chars.length - 1; trail >= 0 && Character.isWhitespace(chars[trail]); --trail) {
            }
            boolean previousWhite = false;
            for (int i2 = lead; i2 <= trail; ++i2) {
                char c2 = chars[i2];
                if (!Character.isWhitespace(c2)) {
                    previousWhite = false;
                    if (",=<>;\"\\".indexOf(c2) >= 0) {
                        buf.append('\\');
                    }
                    buf.append(c2);
                    continue;
                }
                if (previousWhite) continue;
                previousWhite = true;
                buf.append(c2);
            }
            typeAndValue.append(buf.toString().trim());
        }
        String canon = typeAndValue.toString();
        canon = canon.toUpperCase(Locale.US).toLowerCase(Locale.US);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2253CanonicalString:canon", canon);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toRFC2253CanonicalString", "DONE");
        }
        String normalized = Normalizer.normalize(canon, Normalizer.DECOMP_COMPAT, 0);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2253CanonicalString:normalized", normalized);
        }
        return normalized;
    }

    private String toKeywordValueString(String keyword) {
        StringBuilder retval = new StringBuilder(40);
        retval.append(keyword);
        retval.append("=");
        try {
            String temp = this.getValueStr();
            if (temp == null) {
                byte[] data = this.value.toByteArray();
                retval.append('#');
                for (int i2 = 0; i2 < data.length; ++i2) {
                    retval.append("0123456789ABCDEF".charAt(data[i2] >> 4 & 0xF));
                    retval.append("0123456789ABCDEF".charAt(data[i2] & 0xF));
                }
            } else {
                int i3;
                boolean quoteNeeded = false;
                int len = temp.length();
                for (i3 = 0; i3 < specialChars.length(); ++i3) {
                    if (temp.indexOf(specialChars.charAt(i3)) == -1) continue;
                    quoteNeeded = true;
                    break;
                }
                if (!(len <= 0 || quoteNeeded || temp.charAt(0) != ' ' && temp.charAt(0) != '\n' && temp.charAt(len - 1) != ' ' && temp.charAt(len - 1) != '\n')) {
                    quoteNeeded = true;
                }
                if (len > 0 && !quoteNeeded) {
                    boolean lastWasSpace = false;
                    for (i3 = 1; i3 < len - 2; ++i3) {
                        if (temp.charAt(i3) == ' ' || temp.charAt(i3) == '\n') {
                            if (lastWasSpace) {
                                quoteNeeded = true;
                                break;
                            }
                            lastWasSpace = true;
                            continue;
                        }
                        lastWasSpace = false;
                    }
                }
                if (quoteNeeded) {
                    retval.append('\"');
                }
                for (i3 = 0; i3 < len; ++i3) {
                    char c2 = temp.charAt(i3);
                    if (c2 == '\"' || c2 == '\\') {
                        retval.append('\\');
                    }
                    retval.append(c2);
                }
                if (quoteNeeded) {
                    retval.append('\"');
                }
            }
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("DER Value conversion");
        }
        return retval.toString();
    }

    private String getValueStr() throws IOException {
        if (this.valueString == null) {
            byte[] retVal = null;
            switch (this.value.getTag()) {
                case 30: {
                    this.valueString = this.value.getBMPStringAsString();
                    break;
                }
                case 20: {
                    retVal = this.value.getDataBytes();
                    this.valueString = new String(retVal, "ISO-8859-1");
                    break;
                }
                case 19: {
                    retVal = this.value.getDataBytes();
                    this.valueString = new String(retVal, "UTF-8");
                    break;
                }
                case 0: {
                    retVal = this.value.getDataBytes();
                    this.valueString = DerValue.getUniversalString(retVal);
                    break;
                }
                case 12: {
                    retVal = this.value.getDataBytes();
                    this.valueString = DerValue.getUTF8String(retVal);
                    break;
                }
                case 22: {
                    this.valueString = this.value.getIA5String();
                    break;
                }
                default: {
                    retVal = this.value.getDataBytes();
                    this.valueString = new String(retVal, "UTF-8");
                }
            }
        }
        return this.valueString;
    }

    public String getValue() {
        StringBuilder retval = new StringBuilder(30);
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
        }
        try {
            String temp = this.value.getAsString().trim();
            if (temp == null) {
                byte[] data = this.value.toByteArray();
                retval.append('#');
                for (int i2 = 0; i2 < data.length; ++i2) {
                    retval.append("0123456789ABCDEF".charAt(data[i2] >> 4 & 0xF));
                    retval.append("0123456789ABCDEF".charAt(data[i2] & 0xF));
                }
            } else {
                int i3;
                boolean quoteNeeded = false;
                int len = temp.length();
                for (i3 = 0; i3 < specialChars.length(); ++i3) {
                    if (temp.indexOf(specialChars.charAt(i3)) == -1) continue;
                    quoteNeeded = true;
                    break;
                }
                if (!(len <= 0 || quoteNeeded || temp.charAt(0) != ' ' && temp.charAt(0) != '\n' && temp.charAt(len - 1) != ' ' && temp.charAt(len - 1) != '\n')) {
                    quoteNeeded = true;
                }
                if (len > 0 && !quoteNeeded) {
                    boolean lastWasSpace = false;
                    for (i3 = 1; i3 < len - 2; ++i3) {
                        if (temp.charAt(i3) == ' ' || temp.charAt(i3) == '\n') {
                            if (lastWasSpace) {
                                quoteNeeded = true;
                                break;
                            }
                            lastWasSpace = true;
                            continue;
                        }
                        lastWasSpace = false;
                    }
                }
                if (quoteNeeded) {
                    retval.append('\"');
                }
                for (i3 = 0; i3 < len; ++i3) {
                    char c2 = temp.charAt(i3);
                    if (c2 == '\"' || c2 == '\\') {
                        retval.append('\\');
                    }
                    retval.append(c2);
                }
                if (quoteNeeded) {
                    retval.append('\"');
                }
            }
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getValue", e2);
            }
            throw new IllegalArgumentException("DER Value conversion");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue", retval.toString());
        }
        return retval.toString();
    }

    public ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
            debug.exit(16384L, (Object)className, "getOID", this.oid);
        }
        return this.oid;
    }

    public DerValue getDerValue() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDerValue");
        }
        if (this.value != null) {
            DerValue retval = new DerValue(this.value.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDerValue_1", retval);
            }
            return retval;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDerValue_2", this.value);
        }
        return this.value;
    }
}

