/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import sun.net.www.ParseUtil;

public final class PropertyExpander {
    public static String expand(String value) throws ExpandException {
        return PropertyExpander.expand(value, false);
    }

    public static String expand(String value, boolean encodeURL) throws ExpandException {
        if (value == null) {
            return null;
        }
        int p2 = value.indexOf("${", 0);
        if (p2 == -1) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value.length());
        int max = value.length();
        int i2 = 0;
        while (p2 < max) {
            int pe;
            if (p2 > i2) {
                sb.append(value.substring(i2, p2));
                i2 = p2;
            }
            if ((pe = p2 + 2) < max && value.charAt(pe) == '{') {
                if ((pe = value.indexOf("}}", pe)) == -1 || pe + 2 == max) {
                    sb.append(value.substring(p2));
                    break;
                }
                sb.append(value.substring(p2, ++pe + 1));
            } else {
                while (pe < max && value.charAt(pe) != '}') {
                    ++pe;
                }
                if (pe == max) {
                    sb.append(value.substring(p2, pe));
                    break;
                }
                String prop = value.substring(p2 + 2, pe);
                if (prop.equals("/")) {
                    sb.append(File.separatorChar);
                } else {
                    String val = System.getProperty(prop);
                    if (val != null) {
                        if (encodeURL) {
                            try {
                                if (sb.length() > 0 || !new URI(val).isAbsolute()) {
                                    val = ParseUtil.encodePath(val);
                                }
                            }
                            catch (URISyntaxException use) {
                                val = ParseUtil.encodePath(val);
                            }
                        }
                        sb.append(val);
                    } else {
                        throw new ExpandException("unable to expand property " + prop);
                    }
                }
            }
            if ((p2 = value.indexOf("${", i2 = pe + 1)) != -1) continue;
            if (i2 >= max) break;
            sb.append(value.substring(i2, max));
            break;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(PropertyExpander.expand(args[0]));
    }

    public static class ExpandException
    extends GeneralSecurityException {
        static final long serialVersionUID = 5506689582328990942L;

        public ExpandException(String msg) {
            super(msg);
        }
    }
}

